@extends('app')
@section('title', 'Gestion des classes')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between mb-0 pb-0">
                                    <h4>Liste de classe</h4>
                                    <strong style="font-size: 17px">{{$classe['libelle']}} [Effectif : {{count($data) <= 9 ? '0'.count($data):count($data)}}]</strong>
                                    <div class="right">
                                        <span style="float: right">
                                            @if (in_array($classe['type'], ['secondaire', 'technique']))
                                                <a href="{{route('conduite.index',$classe['id'])}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mr-2" title="Generate Conduite"><i class="fas fa-book-reader m-0"></i></a>
                                            @endif
                                            <a href="{{route('sanction.index')}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="simpletable"
                                        class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%"></th>
                                                <th style="width: 10%">Matricule</th>
                                                <th style="width: 22%">Nom et Prenoms</th>
                                                <th style="width: 12%">Genre</th>
                                                <th style="width: 12%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($data as $item)
                                            <tr>
                                                <th class="text-center py-1">
                                                    <img src="{{ asset($item['sexe'] == 'F' ? 'assets/images/admin_woman.png':'assets/images/admin_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                </th>
                                                <td>{{$item['matricule']}}</td>
                                                <td>{{mb_strtoupper($item['first_name']).' '.ucfirst($item['last_name'])}}</td>
                                                <td>{{ucfirst($item['sexe'] == 'F' ? 'Féminin':'Masculin')}}</td>
                                                <td class="py-1">
                                                    <div class="card-block remove-label m-0 p-0 pt-1 text-center">
                                                        <a href="{{route('sanction.create', $item['id'])}}" class="btn btn-sm btn-info text-center px-2" title="Détail sanctions"><i class="fas fa-align-left m-0"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/js/data-table-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){
           
        })
    </script>
@endsection