@extends('app')
@section('title', 'Evaluation par matière')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Liste d'évaluation {{$class->libelle}}</h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <strong class="mr-2" title="{{ucfirst($matter->matter['libelle'])}}">{{ucfirst($matter->matter['abbreviated'] ?? $matter->matter['libelle'])}}</strong>[{{$teacher ? ($teacher->user->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($teacher->user->first_name).' '.ucwords($teacher->user->last_name):'Non défini'}}]
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" id="getAdd" title="New evaluation" data-toggle="modal" data-target="#addModal" style="display: none"><i class="fas fa-plus mx-0"></i></button>
                                        <a href="#" id="btnList" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Liste des notes"><i class="fas fa-ellipsis-h mx-0"></i></a>
                                        <input type="hidden" id="getCuttingId" value="">
                                        <a href="{{ route('evaluation.index') }}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mt-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        @foreach ($cutting as $item)
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left {{$item['actif'] == 1 ? 'active':''}}" data-lib="{{$item['libelle']}}" id="{{$item['actif'] == 1 ? 'active':'inactif'}}" data-actif="{{$item['actif']}}" data-id="{{$item['id']}}" data-toggle="tab" href="#home{{$item['id']}}" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i>{{ucfirst($item['libelle'])}} [{{count($item['data']) <= 9 ? '0'.count($item['data']):count($item['data'])}}]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        @foreach ($cutting as $item)
                                        <div class="tab-pane {{$item['actif'] == 1 ? 'active':''}}" id="home{{$item['id']}}" role="tabpanel">
                                            <table id="{{$item['tab']}}" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center">Libelle</th>
                                                        <th class="text-center">Date</th>
                                                        <th class="text-center">Noté sur</th>
                                                        <th class="text-center">Status</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $i = 1; @endphp
                                                    @foreach ($item['data'] as $val)
                                                    <tr>
                                                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                                                        <td class="text-center">{{ucfirst($val->evaluationType->type)}} {{ $val->sub_matter_id ? ' ['.$val->subMatter->abbreviated.']':null}}</td>
                                                        <td class="text-center">{{date('d/m/Y', strtotime($val['date_create']))}}</td>
                                                        <td class="text-center">{{$val['notee'] * 20}}</td>
                                                        <td class="text-center"> <span class="label label-{{$val->status ? 'success':'danger'}}">{{$val['status'] ? 'Actif':'Inactif'}}</span></td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <a href="{{route('evaluation.show',$val->id)}}" class="btn btn-sm btn-info text-center px-2 ml-2" title="View Note" disabled="disabled"><i class="fas fa-sticky-note m-0"></i></a>
                                                                @if (!$item['approved'])
                                                                <a href="{{ route('evaluation.catchingUp', $val->id) }}" class="btn btn-sm btn-instagram text-center px-2 ml-2" title="Ratrapage Note"><i class="fas fa-location-arrow m-0"></i></a>
                                                                <button class="editEval btn btn-sm btn-warning text-center px-2 ml-2" data-id="{{$val->id}}" data-toggle="modal" data-target="#editModal" title="Edit Evaluation"><i class="far fa-edit m-0"></i></button>
                                                                <button class="getDelet btn btn-sm btn-danger text-center px-2 ml-2" title="Delete Evaluation" data-val="{{$val['id'].'_'.$class['id']}}" data-toggle="modal" data-target="#deleteModal"><i class="far fa-trash-alt m-0"></i></button>
                                                                @endif
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Create Evavuation -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addModalLongTitle">New Evaluation</h5>
        </div>
        <form action="{{route('evaluation.store')}}" method="post">
            @csrf
            <input type="hidden" name="idMatter" value="{{$matter->id}}">
            <input type="hidden" name="idClass" value="{{$class->id}}">
            <input type="hidden" name="idCutting" value="" id="idCutting">
            <div class="modal-body">
                @if($sub_matter)
                <div class="mb-3">
                    <label for="submatter">Sous matière<span class="text-danger">*</span> : </label>
                    <select name="submatter" class="form-control" id="submatter">
                        <option value=" ">Select one option</option>
                        @foreach ($sub_matter as $item)
                        <option value="{{$item->id}}">{{ucfirst($item->libelle)}}</option>
                        @endforeach
                    </select>
                </div>
                @endif
                <div class="mb-3">
                    <label for="select">Type d'évaluation<span class="text-danger">*</span> : </label>
                    <select name="select" class="form-control" id="select">
                        <option value=" ">Select one option</option>
                        @foreach ($type as $item)
                        <option value="{{$item->id}}">{{ucfirst($item->type)}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="mb-3">
                    <label for="note">Notée <span class="text-danger">*</span> : </label>
                    <select name="notee" class="form-control" id="note">
                        <option value=" ">---</option>
                        <option value="0.5">Sur 10</option>
                        <option value="1">Sur 20</option>
                        <option value="1.5">Sur 30</option>
                        <option value="2">Sur 40</option>
                        <option value="2.5">Sur 50</option>
                        <option value="3">Sur 60</option>
                        <option value="4">Sur 80</option>
                        <option value="5">Sur 100</option>
                    </select>
                </div>
                <div class="mb-2">
                    <label for="date">Date d'évaluation<span class="text-danger">*</span> : </label>
                    <input type="date" name="date" class="form-control" id="date">
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- Modal Edit Evaluation -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="eeditModalTitle">Edit Evaluation</h5>
        </div>
        <form action="#" method="post" id="myEdit">
            @csrf
            @method('put')
            <input type="hidden" name="string" value="{{$class->id.'_'.$matter->id}}">
            <div class="modal-body">
                <div class="mb-3" id="divSubmatter" style="display: none">
                    <label for="submatterEdit">Sous matière<span class="text-danger">*</span> : </label>
                    <select name="submatter" class="form-control" id="submatterEdit">
                    </select>
                </div>
                <div class="mb-3">
                    <label for="typeEval">Type d'évaluation<span class="text-danger">*</span> : </label>
                    <select name="select" class="form-control" id="typeEval">
                    </select>
                </div>
                <div class="mb-3">
                    <label for="typeNote">Notée <span class="text-danger">*</span> : </label>
                    <select name="notee" class="form-control" id="typeNote">
                    </select>
                </div>
                <div class="mb-3">
                    <label for="dateEval">Date d'évaluation<span class="text-danger">*</span> : </label>
                    <input type="date" name="date" class="form-control" id="dateEval">
                </div>
                <div class="mb-2">
                    <input type="checkbox" name="status" id="status" value="1">
                    <label for="status" id="libelle"></label>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>

<!-- Modal Delete Evaluation-->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="deleteModalLongTitle">Delete Evaluation</h5>
        </div>
        <div class="modal-body text-center py-3">
            <div class="mt-3" id="deleteContent"></div>
            <p class="my-2">Confirmez la suppression !</p>
        </div>
        <form method="post" id="myDelete">
            @csrf
            @method('delete')
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){

            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("evaluation");

            $actif = $("#active").data('actif');
            if($actif && $actif != 2){
                $('#getAdd').slideDown()
            }
            else{
                $('#getAdd').slideUp()
            }
            // $actif == 2 ? $('#getAdd').slideUp():$('#getAdd').slideDown();   
            $('#getCuttingId').val($("#active").data('id'));
            $('#btnList').attr('href', debutUrl[0]+'evaluation/note_listes/'+{{$class->id}}+'_'+$("#active").data('id')+'_'+{{$matter->id}});

            $('.nav-link').on('click', function(){
                $actif = $(this).data('actif');
                $actif == 2 ? $('#getAdd').hide():$('#getAdd').slideDown();
                $('#getCuttingId').val($actif == 2 ? null:$(this).data('id'));
                $('#btnList').attr('href', debutUrl[0]+'evaluation/note_listes/'+{{$class->id}}+'_'+$(this).data('id')+'_'+{{$matter->id}});
            });

            $('#getAdd').on('click', function() {
                $('#idCutting').val($('#getCuttingId').val());
            });

            // Edition d'evaluation AJAX
            $(document).on('click', '.editEval', function() {
                $val = $(this).data('id'); $('.class').remove();
                $('#myEdit').attr('action', debutUrl[0]+'evaluation/editEval/'+$val);
                $.ajax({
                    url: '{{ route('evaluation.edit') }}',
                    method: 'GET',
                    data: { id: $val },
                    success: function(data){
                        $('div#editModal').fadeIn();
                        $note = [0.5, 1, 1.5, 2, 2.5, 3, 3.5, 4, 5];
                        $('#dateEval').val(data['eval'].date_create);
                        data['eval'].status == 1 ? $('#status').attr('checked',true):$('#status').attr('checked',false);
                        data['eval'].status == 1 ? $('#libelle').text('Actif'):$('#libelle').text('Inactif');
                        if(data['eval'].sub_matter_id){
                            $('#divSubmatter').slideDown();
                            $i = 0;
                            while ($i < data['subMatter'].length) {
                                $selected = data['eval'].sub_matter_id == data['subMatter'][$i].id ? 'selected':null;
                                $('#submatterEdit').append('<option class="class" value="'+data['subMatter'][$i].id+'" '+$selected+'>'+data['subMatter'][$i].libelle+'</option>');
                                $i++;
                            }
                        }

                        // Add type Evaluation end select
                        $i = 0;
                        while ($i < data['type'].length) {
                            $selected = data['eval'].evaluation_type_id == data['type'][$i].id ? 'selected':null;
                            $('#typeEval').append('<option class="class" value="'+data['type'][$i].id+'" '+$selected+'>'+data['type'][$i].type+'</option>');
                            $i++;
                        }

                        // Add note evaluation end select
                        $i = 0;
                        while ($i < $note.length) {
                            $selected = data['eval'].notee == $note[$i] ? 'selected':null;
                            $('#typeNote').append('<option class="class" value="'+$note[$i]+'" '+$selected+'>Sur '+$note[$i]*20+'</option>');
                            $i++;
                        }
                    }
                });
            });

            // Suppression d'évaluation.......................
            $(document).on('click', '.getDelet', function() {
                $val = $(this).data('val');
                $('#getContent').remove();
                $('#myDelete').attr('action', debutUrl[0]+'evaluation/destroy/'+$val);
                $.ajax({
                    url: '{{ route('evaluation.delete') }}',
                    method: 'GET',
                    data: { val: $val },
                    success: function(data){
                        $('div#deleteModal').fadeIn();
                        $('#deleteContent').append('<strong id="getContent"><span class="my-2" style="font-size: 17px">'+data.type+'</span><br> du '+data.date+'</strong>');
                    }
                });
            });

        })
    </script>
@endsection