@extends('app')
@section('title', 'Composition')
@section('link')
<!-- Data Table Css -->
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('assets/pages/data-table/css/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-0 mb-0">
                                    <h4>{{ucwords($evaluated->evaluated->libelle)}}</h4>
                                    <span class="form-control-variant" style="font-size: 17px">
                                        <strong class="mr-2">{{$classe->libelle}}</strong>
                                    </span>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Loading file" data-toggle="modal" data-target="#fileModal"><i class="fas fa-ellipsis-h mx-0"></i></button>
                                        <a href="{{route('evaluation.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 mt-0">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <table id="saving-reorder" class="table table-striped table-bordered nowrap">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 5%">N°</th>
                                                <th class="text-center" style="width: 20%">Nom & Prénoms</th>
                                                <th class="text-center" style="width: 5%">Sexe</th>
                                                @foreach ($matters as $matter)
                                                <th class="text-center" title="{{$matter->primary_matter->libelle}}">{{$matter->primary_matter->abbreviated}}</th>
                                                @endforeach
                                                <th class="text-center" style="width: 8%" title="Point obtenu">Point</th>
                                                <th class="text-center" style="width: 8%" title="Moyenne">Moyen</th>
                                                <th class="text-center" style="width: 8%" title="Rang">Rang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($datas as $item)
                                            <tr>
                                                <th class="text-center py-1">
                                                    <img src="{{ asset($item['sexe'] == 'F' ? 'assets/images/admin_woman.png':'assets/images/admin_man.png') }}" class="img-radius m-0 p-0" alt="Photo Stuedent" style="height: 40px; width: 40px; border: 1px solid grey">
                                                </th>
                                                <td class="text-left ml-2" title="{{ $item['name'] }}">{{ Str::limit($item['name'], '20', '...') }}</td>
                                                <td class="text-center">{{$item['sexe']}}</td>
                                                @foreach ($item['notes'] as $note)
                                                <td class="text-center">{{($note['note']['note'] ?? '---').' / '.$note['valeur']}}</td>
                                                @endforeach
                                                <td class="text-center">{{($item['resultat']['point'] ?? '---').' / '.calculTotatPoint($item['notes'])}}</td>
                                                <td class="text-center">{{($item['resultat']['moyenne'] ?? '---').' / 10'}}</td>
                                                <td class="text-center">{{$item['resultat']['rang'] ?? '---'}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="fileModal" tabindex="-1" role="dialog" aria-labelledby="fileModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="fileModalLongTitle">Importion fiche de note</h5>
        </div>
        <form action="{{route('composition.import')}}"method="post" enctype="multipart/form-data">
            @csrf
            <div class="modal-body">
                <div class="m-b-30">
                    <span class="d-flex justify-content-between mb-2">
                        <label for="files">Importer la fiche<span class="text-danger">*</span> : </label>
                        <a href="{{route('composition.file',$evaluated->evaluated->id.'_'.$classe->id)}}" class="btn btn-inverse btn-outline-inverse btn-sm py-1" title="Download file"><i class="fas fa-download mx-0"></i> </a>
                    </span>
                    <input type="file" name="files" id="files" class="form-control" placeholder="Importer le fichier format Excel">
                </div>
                <input type="hidden" name="class" value="{{$classe->id}}">
                <input type="hidden" name="evaluated" value="{{$evaluated->evaluated->id}}">
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
@endsection
@section('script')
    <!-- data-table js -->
    <script src="{{asset('bower_components/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')}}"></script>
    <script src="{{asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
    <!-- Custom js -->
    <script src="{{asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')}}"></script>
    <script src="{{asset('assets/js/pcoded.min.js')}}"></script>
    <script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>
    <script>
        $(document).ready(function(){


        })
    </script>
@endsection