<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_transports', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('payer');
            $table->enum('tours',[1, 2]);
            $table->enum('trim_1',[0, 1])->default('0');
            $table->enum('trim_2',[0, 1])->default('0');
            $table->enum('trim_3',[0, 1])->default('0');
            $table->enum('semest_1',[0, 1])->default('0');
            $table->enum('semest_2',[0, 1])->default('0');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('payment_id');
            $table->unsignedBigInteger('transport_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('payment_id')->references('id')->on('payments')->onDelete('cascade');
            $table->foreign('transport_id')->references('id')->on('transports')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_transports');
    }
};
