<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('libelle_bilan_matter', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('libelle_bilan_id');
            $table->unsignedBigInteger('matter_id');
            $table->enum('type', ['secondaire', 'superieur', 'technique']);
            $table->integer('bilan')->nullable();
            $table->foreign('libelle_bilan_id')->references('id')->on('libelle_bilans')->onDelete('cascade');
            $table->foreign('matter_id')->references('id')->on('matters')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('libelle_bilan_matter');
    }
};
