<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class PasswordController extends Controller
{
    // Traiter la soumission du formulaire de changement de mot de passe
    public function passwordChange(Request $request)
    {
        // Valider les données
        $request->validate([
            'current_password' => ['required', 'string', 'min:6', 'max:255'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);

        // Vérifier que le mot de passe actuel est correct
        if (!Hash::check($request->current_password, Auth::user()->password)) {
            return back()->withErrors(['current_password' => 'Le mot de passe actuel est incorrect.']);
        }

        // Mettre à jour le mot de passe de l'utilisateur
        Auth::user()->update([
            'password' => Hash::make($request->password),
        ]);

        // Retourner à la page d'accueil ou à une autre page avec un message de succès
        return redirect()->route('dashboard')->with([
            'str' => 'info',
            'msg' => 'Votre mot de passe à été changé !'
        ]);
    }
}
