<?php $__env->startSection('title', 'Detail eleve'); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <div class="main-body">
        <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body mb-0 pb-0">
                                <div class="card-header pb-2">
                                    <div class="d-flex justify-content-between">
                                        <h4>Détail élève</h4>
                                        <span>
                                            <a href="<?php echo e(route('student.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <hr class="my-0 mx-3">
                                <div class="row py-3">
                                    <div class="col-sm-5 text-center pt-md-5">
                                        <?php if($data->photo): ?>
                                        <img src="<?php echo e(asset($data->urlStudent())); ?>" class="img-radius mx-0 w-25" alt="User-Profile-Image">
                                        <?php else: ?>
                                        <img src="<?php echo e(asset($data->sexe == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')); ?>" class="img-radius mx-0" alt="User-Profile-Image" style="width:40px">
                                        <?php endif; ?>
                                        <h4 class="mb-1 mt-2"><?php echo e(ucfirst($data->first_name).' '.ucfirst($data->last_name)); ?></h4>
                                        <p class="text-muted"><strong><?php echo e(ucfirst($data->matricule)); ?></strong></p>
                                        <p>
                                            <?php echo e(mb_strtoupper($data->parentEleve->first_name).' '.ucfirst($data->parentEleve->last_name.' / '.$data->parentEleve->profession)); ?> <br>
                                            <strong>[<?php echo e($data->parentEleve->telephon1); ?> <?php echo e($data->parentEleve->telephon2 ? ' / '.$data->parentEleve->telephon2:null); ?>]</strong>
                                        </p>
                                        <a href="<?php echo e(route('student.edit',$data->id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 my-1"><i class="fas fa-edit"></i> Editer</a>
                                    </div>
                                    <div class="col-sm-7">
                                        <div class="text-start mt-3">
                                            <table class="table table-bordered mt-0">
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Matricule</span></td>
                                                        <td><strong><?php echo e($data->matricule); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nom</span></td>
                                                        <td><strong><?php echo e(mb_strtoupper($data->first_name)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Prénoms</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->last_name)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Genre</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->sexe == 'F' ? 'Féminin':'Masculin')); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Date et lieu de naissance</span></td>
                                                        <td>Né<?php echo e($data->sexe == 'F' ? 'e':''); ?> le <strong><?php echo e($data->date_birth); ?></strong> à <strong><?php echo e(ucfirst($data->place_birth)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Nationalité</span></td>
                                                        <td><strong><?php echo e(ucfirst($data->nationalitie->libelle)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Père biologique</span></td>
                                                        <td><strong><?php echo e(mb_strtoupper($data->first_name_father).' '.ucfirst($data->last_name_father.' / '.$data->profession_father)); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Mère biologique</span></td>
                                                        <td>
                                                            <strong>
                                                                <?php echo e(mb_strtoupper($data->first_name_mother).' '.ucfirst($data->last_name_mother.' / '.$data->profession_mother)); ?>

                                                            </strong>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Type d'enseignement </span></td>
                                                        <td><strong><?php echo e(ucfirst($data->type)); ?></strong</td>
                                                    </tr>
                                                    <tr>
                                                        <td style="width: 250px"><span style="font-size: 14px">Disponibilité </span></td>
                                                        <td><strong><?php echo e(ucfirst($data->status ? 'Oui':'Non')); ?></strong</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-10 offset-md-1">
                                        <h5 class="fs-10 text-uppercase mb-1">Parcours scolaire</h5>
                                        <table class="table table-bordered mt-0">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width:25px">N°</th>
                                                    <th style="width:100px">Année scolaire</th>
                                                    <th style="width:100px">Niveau</th>
                                                    <th style="width:100px">Classe</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $data->inscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                    <td><?php echo e($item->schoolYear->school_year); ?><strong class="text-danger"><?php echo e($item->schoolYear->id == $year->id ? '*':null); ?></strong></td>
                                                    <td><?php echo e(ucwords($item->level->code)); ?></td>
                                                    <td><?php echo e(ucwords($item->classe->libelle)); ?></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pages/student/detail.blade.php ENDPATH**/ ?>