<?php $__env->startSection('title', 'Add teacher'); ?>
<?php $__env->startSection('link'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
<style>
    .blink {
        color: red !important;
        font-size: 15px;
        animation: blinker 1.5s linear infinite;
    }
    @keyframes blinker {  
      50% { opacity: 0; }
    }
    .form-filed{
        background-color: red !important; 
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between pb-2">
                                    <h4 class="m-0">Ajout d'Enseignant</h4>
                                    <h4 class="m-0"><strong><?php echo e($classe['libelle']); ?></strong></h4>
                                    <div class="right">
                                        <span style="float: right">
                                            <a href="<?php echo e(route('time.index',$classe->id.'_'.$string)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply m-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <form action="<?php echo e(route('time.add_store')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="card-block mt-3" style="width: 100%; margin: 1px auto">
                                    <?php if(!(count($matter) && count($profs))): ?>
                                        <div class="text-center my-3">
                                            <strong class="blink">Configuration Incomplète ...</strong>
                                        </div>
                                    <?php endif; ?>
                                    <div class="dt-responsive table-responsive">
                                        <table id="autofill" class="table table-bordered" style="line-height: 0%">
                                            <thead>
                                                <tr>
                                                    <th class="text-center py-4" style="width: 10%">N°</th>
                                                    <th class="text-center py-4" style="width: 30%">Dsicpline</th>
                                                    <th class="text-center py-4" style="width: 30%">Enseignant</th>
                                                    <th class="text-center py-4" style="width: 10%" title="Professeur Principal">PP</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(count($matter) && count($profs)): ?>
                                                <?php $i = 1; ?>
                                                <?php $__currentLoopData = $matter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr title="<?php echo e($item->libelle); ?>">
                                                    <th class="text-center  pt-4"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                    <td class="text-left pt-4" title="<?php echo e($item->libelle); ?>">
                                                        <span class="mx-3"><?php echo e(ucfirst($item->abbreviated ?? $item->libelle)); ?></span>
                                                        <input type="hidden" name="matter[]" value="<?php echo e($item->id); ?>">
                                                    </td>
                                                    <td class="p-0">
                                                        <select name="profs[]" class="form-filed w-100" style="border: none">
                                                            <option value="">Select Teacher</option>
                                                            <?php $__currentLoopData = $profs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($prof->id); ?>" <?php echo e(verifyteacherClass($exists,$item->id, $prof->id) ? 'selected':null); ?>><?php echo e(($prof->sexe == "F" ? 'Mde. ':'Mr. ').strtoupper($prof->first_name).' '.ucwords($prof->last_name)); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>   
                                                    </td>
                                                    <td class="text-center">
                                                        <input type="radio" name="pp" value="<?php echo e($i-1); ?>" <?php echo e(verifyteacherClass($exists,$item->id, $prof->id, 1) ? 'checked':null); ?>>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="5" class="py-4 text-center">
                                                            <strong style="font-size: 14px">Veuillez faire une bonne configuration.</strong>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <input type="hidden" name="class" value="<?php echo e($classe['id']); ?>">
                                    <input type="hidden" name="infoClass" value="<?php echo e($classe->id.'_'.$string); ?>">
                                    <div class="row text-center">
                                        <div class="col-sm-12 invoice-btn-group text-center my-3">
                                            <button type="submit" class="btn btn-inverse btn-outline-inverse py-1" <?php echo e((count($matter) && count($profs)) ? null:'disabled'); ?>> <i class="fas fa-check-circle" ></i> Valider les informations</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            $('.form-filed').select2({
                theme: 'bootstrap-5'
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/v4-test/app_v4_teste/resources/views/pages/times/add_teacher.blade.php ENDPATH**/ ?>