<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resultat_examens', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('ivoirien_g')->nullable();
            $table->string('ivoirien_f')->nullable();
            $table->string('etranger_g')->nullable();
            $table->string('etranger_f')->nullable();
            $table->string('ivoirien_g_ad')->nullable(); // Ivoirien garçon nombre d'adminission
            $table->string('ivoirien_f_ad')->nullable(); // Ivoirien fille nombre d'adminission
            $table->string('etranger_g_ad')->nullable(); // Etranger garçon nombre d'adminission
            $table->string('etranger_f_ad')->nullable();  // Etranger fille nombre d'adminission
            $table->string('ivoirien_g_pr')->nullable(); // Ivoirien garçon pourcentage d'adminission
            $table->string('ivoirien_f_pr')->nullable(); // Ivoirien fille pourcentage d'adminission
            $table->string('ivoirien_t_pr')->nullable(); // Ivoirien pourcentage d'adminission
            $table->string('etranger_g_pr')->nullable(); // Etranger garçon pourcentage d'adminission
            $table->string('etranger_f_pr')->nullable(); // Etranger fille pourcentage d'adminission
            $table->string('etranger_t_pr')->nullable(); // Etranger pourcentage d'adminission
            $table->enum('order',[1,2,3,4,5,6]);
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resultat_examens');
    }
};
