<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resultat_classes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('moyenne');
            $table->string('rang')->nullable();
            $table->string('moyenne_elevee_classe')->nullable();
            $table->string('moyenne_moins_classe')->nullable();
            $table->string('nbre_non_classe')->nullable();
            $table->string('nbre_superieur')->nullable()->comment('moyenne superieur ou egal a 10'); 
            $table->string('nbre_entre')->nullable()->comment('moyenne comprise entre 9.99 et 8.5');
            $table->string('nbre_inferieur')->nullable()->comment('moyenne inferieur a 8.5');
            $table->unsignedBigInteger('classe_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('cutting_school_year_id');
            $table->foreign('classe_id')->references('id')->on('classes')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('cutting_school_year_id')->references('id')->on('cutting_school_year')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resultat_classes');
    }
};
