<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('absences', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('justified', [0,1])->default(0);
            $table->enum('period', [1,2]);
            $table->string('dateAbsence');
            $table->string('motifs')->nullable();
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('matter_id');
            $table->unsignedBigInteger('classe_id');
            $table->unsignedBigInteger('cutting_school_year_id');
            $table->unsignedBigInteger('time_morning_id')->nullable();
            $table->unsignedBigInteger('time_after_id')->nullable();
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->foreign('matter_id')->references('id')->on('matters')->onDelete('cascade');
            $table->foreign('classe_id')->references('id')->on('classes')->onDelete('cascade');
            $table->foreign('cutting_school_year_id')->references('id')->on('cutting_school_year')->onDelete('cascade');
            $table->foreign('time_morning_id')->references('id')->on('time_mornings')->onDelete('cascade');
            $table->foreign('time_after_id')->references('id')->on('time_afters')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('absences');
    }
};
