<?php

namespace App\Jobs;

use App\Models\Classe;
use App\Models\ResultatClasse;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class ClassementClasseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $class;
    protected $decoupage;
    // protected $yearActif;
    /**
     * Create a new job instance.
     */
    public function __construct($class, $decoupage)
    {
        $this->class = $class;
        $this->decoupage = $decoupage;
    }


    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $dts = $this->classement($this->moyenneGet());
        foreach($dts as $item){
            ResultatClasse::where('id', $item['id'])->update(['rang' => $item['rang']]);
        }
    }


    private function moyenneGet()
    {
        $level = $this->getLevelid();
        $data = DB::table('resultat_classes')
        ->join('classes', 'classes.id', '=', 'resultat_classes.classe_id')
        ->select('resultat_classes.id', 'resultat_classes.moyenne as moyen')
        ->where('resultat_classes.cutting_school_year_id', '=', $this->decoupage)
        ->where('classes.level_id', '=', $level)
        ->get();
        return json_decode($data, true);
    }



    private function getLevelid()
    {
        $class = Classe::where('id', $this->class)->first();
        return $class->level_id;
    }



    private function classement($data)
    {
        array_multisort(array_column($data, 'moyen'), SORT_DESC, $data);
        $previous_score = null;
        $rank = 1;
        $adjusted_rank = 1;
        $tab = [];
        foreach ($data as $item) {
            if ($previous_score === $item['moyen']){
                $item['rang'] = $adjusted_rank.'ex';
                $tab[] = $item;
            } 
            else {
                $item['rang'] = $item['moyen'] == 'nc' ? '--':($rank > 1 ? $rank.'eme':$rank.'ere');
                $tab[] = $item;
                $adjusted_rank = $item['moyen'] == 'nc' ? '--':$rank;
            }
            $previous_score = $item['moyen'] == 'nc' ? $previous_score:$item['moyen'];
            $item['moyen'] == 'nc' ? $rank:$rank++;
        }
        return $tab;
    }

}
