
@extends('app')
@section('title', 'Add new matter')
@section('content')
@section('link')
<style>
    .barrer {text-decoration: line-through;}
</style>
@endsection
<div class="pcoded-inner-content">
    @include('includes._alert')
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="card">
                    <div class="card-header mb-0 pb-0">
                        <div class="d-flex justify-content-between pb-1">
                            <h4>Config Disciplines</h4>
                            <div class="text-center" title="Niveau {{ucfirst($level['level'])}}" style="font-size: 17px">
                                {{ucfirst($valeur)}} - <u>{{ucfirst($level['code'] ?? $level['level'])}} {{$serie['serie'] ?? null}}</u>
                                <span>Pour chaque discipline cochée, son coefficient Sinon Décochée.</span>
                            </div>
                            <span>
                                <a href="{{route('matiere.index')}}" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                            </span>
                        </div>
                    </div>
                    <hr class="mx-3 my-0">
                    <div class="card-block mx-3">
                        <div class="text-center my-2">
                            
                        </div>
                        <form action="{{route('getMatter.store')}}" method="post">
                            @csrf
                            <input type="hidden" value="{{$valeur}}" name="type">
                            <input type="hidden" value="{{$level['id'].'_'.ucfirst($level['code'] ?? $level['level'])}}" name="typeId">
                            <input type="hidden" name="serie" value="{{$serie['id'] ?? null}}">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row my-2">
                                        @foreach ($matters as $matter)
                                        <div class="col-12 col-md-4 col-lg-3">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td class="w-25" title="{{$matter['libelle']}}">
                                                            <div class="d-flex justify-content-between m-0 pt-2">
                                                                <span>
                                                                    <input type="checkbox" name="matter[]" class="checkbox" data-id="{{$matter['id']}}" value="{{$matter['id']}}" id="matter_{{$matter['id']}}" checked>
                                                                    <label for="matter_{{$matter['id']}}" id="lib_{{$matter['id']}}">{{ucfirst($matter['abbreviated'] ?? $matter['libelle'])}}</label>
                                                                </span>
                                                                @if ($coeff)
                                                                <span class="d-flex">
                                                                    <label for="coef_{{$matter['id']}}">Coefficeint :</label>
                                                                    <input type="number " name="coef[]" class="form-control my-0 py-1 text-center myInput mx-2" id="coef_{{$matter['id']}}" min="1" maxlength="2" required placeholder="--" style="width: 60px; height: 27px">
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        
                            <hr class="text-center mt-3">
                            <div class="text-center">
                                <button type="submit" class="btn btn-inverse btn-outline-inverse py-2"> <i class="fas fa-check-circle"></i> Valider les informations</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{asset('assets/js/pcoded.min.js')}}"></script>
<script src="{{asset('assets/js/vartical-layout.min.js')}}"></script>
<script src="{{asset('assets/js/jquery.mCustomScrollbar.concat.min.js')}}"></script>

<script>
    $(document).ready(function(){
        $('.checkbox').on('click', function() {
            let valId = 'matter_'+$(this).val();
            let coefId = '#coef_'+$(this).val();
            $lib = '#lib_'+$(this).val()
            // alert(valId);
            if(document.getElementById(valId).checked){
                $(coefId).attr('name', 'coef[]');
                $(coefId).prop('disabled', false);
                $($lib).attr('class', '');
            }
            else{
                $(coefId).attr('name', '');
                $(coefId).val(null);
                $(coefId).prop('disabled', true);
                $($lib).attr('class', 'barrer');
            }
        });


        // Autoriser les touches numériques (0-9) et la touche backspace (code 8)
        $('.myInput').on('keypress', function(e) {
            var key = e.which || e.keyCode;
            if ((key >= 48 && key <= 57) || key === 8 || key === 46 || key === 127) {
                return true;
            } else {
                e.preventDefault();
            }
        });
    })
</script>
@endsection