<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('moyenne_annuelle_sub_matters', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('moyenne_1')->nullable()->comments('Moyenne du 1er trimestre');
            $table->string('moyenne_2')->nullable()->comments('Moyenne du 2eme trimestre');
            $table->string('moyenne_3')->nullable()->comments('Moyenne du 3eme trimestre');
            $table->string('rang_trim')->nullable();
            $table->string('coefficient')->nullable();
            $table->string('moyenne_annuel')->nullable();
            $table->string('rang_annuel')->nullable();
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('sub_matter_id');
            $table->unsignedBigInteger('inscription_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('sub_matter_id')->references('id')->on('sub_matters')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->foreign('inscription_id')->references('id')->on('inscriptions')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('moyenne_annuelle_sub_matters');
    }
};
