<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cutting_school_year', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('school_year_id');
            $table->unsignedBigInteger('cutting_id');
            $table->enum('type',['general', 'technique', 'superieur']);
            $table->string('start_date');
            $table->string('end_date');
            $table->enum('status', [0,1,2])->comment('0 => Decoupage en attente', '1 => Decoupage en cours', '2 => Decoupage terminé');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->foreign('cutting_id')->references('id')->on('cuttings')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cutting_school_year');
    }
};
