<?php

namespace App\Jobs;

use App\Mail\sendEmailWelcome;
use Illuminate\Support\Facades\Mail;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendMailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $user;
    protected $param1;
    protected $param2;
    /**
     * Create a new job instance.
     */
    public function __construct($user, $param1, $param2)
    {
        $this->user = $user;
        $this->param1 = $param1;
        $this->param2 = $param2;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        Mail::to($this->user->email)->send(new sendEmailWelcome($this->user, $this->param1, $this->param2));
    }
}
