<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Program Devoir - <?php echo e($classe['libelle']); ?></title>
</head>
<style type="text/css">
    @page {
        margin: 1.5cm 1cm 0.5cm 1cm; /* haut droite bas gauche */
    }
    body {
        margin: 0cm;
        padding: 0cm;
        font-family: sans-serif;
        font-size: 14px
    }
    .watermark {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%) rotate(-50deg);
        font-size: 100px;
        color: rgba(0, 0, 0, 0.05);
        z-index: -1;
        white-space: nowrap;
        text-decoration: underline;
        pointer-events: none;
    }
    footer{
        position: fixed;
        bottom: -30px;
        border-top: 2px solid gray;
        left: 0;
        right: 0;
        height: 50px;
        text-align: right;
        font-size: 12px;
        color: #555;
    }
</style>
<body>
    <div class="watermark">Classe : <?php echo e($classe->libelle); ?></div>
    <header style="margin-top: 10%; margin-bottom: 10%; ">
        <table style="width: 100%">
            <tbody>
                <tr>
                    <td>
                        <div class="bloc1" style="width: 70%; text-align: center;">
                            <p style="font-size: 14px; margin-bottom: 0%"><strong>MINISTERE DE L’EDUCATION NATIONALE <br> ET DE L’ALPHABETISATION</strong></p>
                            <p style="margin-top:0%">....................................</p>
                            <p style="font-size: 12px; margin-bottom: 5px"><?php echo e($school->school->name_school); ?></p>
                            <img src="<?php echo e(public_path($school->logoUrl())); ?>" class="m-b-10 w-100 my-0" alt="Logo School" style="height: 55px;"><br>
                        </div>
                    </td>

                    <td>
                        <div class="bloc2" style="width: 100%; text-align: center;">
                            <p style="font-weight: bold;">REPUBLIQUE DE COTE D'IVOIRE</p>
                            <p>Union - Discipline - Travail</p>
                            <img src="<?php echo e(public_path('assets/images/armoiries.png')); ?>" class="m-b-10 w-100" alt="Armoirie Ivoirienne" style="height: 55px;">
                            <p style="font-size: 15px; text-decoration: underline; margin-top: 20px">
                                <b style="font-size: 17px"><?php echo e($cutting->schoolYear->school_year); ?></b>
                            </p>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </header>
    <section style="margin-top: 12%;">
        <div style="margin: 1px auto; width: 100%; text-align:center;  margin-bottom: 15%">
            <strong style="font-size: 25px; height: 100px; line-height: 1.3; text-decoration: underline;">PROGRAMME DE DEVOIRS <?php echo e(strtoUpper($cutting->cutting->libelle)); ?></strong>
        </div>

        <p style="margin-top: 30px">
            <table border="1" cellpadding="10" cellspacing="0" style="border-collapse: collapse; width: 100%; border: 1px solid black;">
                <thead>
                    <tr>
                        <th scope="col" class="text-center" style="width: 16%; padding: 17px">MATIERES</th>
                        <th scope="col" class="text-center" style="width: 42%; padding: 17px">MATIN</th>
                        <th scope="col" class="text-center" style="width: 42%; padding: 17px">APRES MIDI</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $matters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th scope="col" style="margin:0%; padding:0%; text-align: left">
                            <span style="margin-left: 5px"><?php echo e($matter['libelle']); ?></span>
                        </th>
                        <td style="margin:<?php echo e(count($matter['martins']) ? '0%':''); ?>; padding:<?php echo e(count($matter['martins']) ? '0%':'20px'); ?>">
                            <?php if(count($matter['martins'])): ?>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 13px; margin:0%">
                                <tbody style="margin:0%; padding:0%">
                                    <tr style="margin:0%;">
                                        <?php $__currentLoopData = $matter['martins']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td style="margin: 0%; text-align:center;">
                                                <?php echo e(ucwords($item['jour'])); ?><br> 
                                                <strong><?php echo e(date('d/m/Y', strtotime($item['date']))); ?></strong><br>
                                                <?php echo e($item['debut']); ?> - <?php echo e($item['fins']); ?>

                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                </tbody>
                            </table>
                            <?php endif; ?>
                        </td>
                        <td style="margin:<?php echo e(count($matter['soirs']) ? '0%':''); ?>; padding:<?php echo e(count($matter['soirs']) ? '0%':'20px'); ?>">
                            <?php if(count($matter['soirs'])): ?>
                            <table border="1" cellpadding="1" cellspacing="0" style="border-collapse: collapse; width: 100%; font-size: 13px; margin:0%">
                                <tbody style="margin:0%; padding:0%">
                                    <tr style="margin:0%;">
                                        <?php $__currentLoopData = $matter['soirs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td style="margin: 0%; text-align:center;">
                                                <?php echo e(ucwords($item['jour'])); ?> <br> 
                                                <strong><?php echo e(date('d/m/Y', strtotime($item['date']))); ?></strong><br>
                                                <?php echo e($item['debut']); ?> - <?php echo e($item['fins']); ?>

                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                </tbody>
                            </table>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </p>
    </section>
    <footer class="footer">
        <div style="display: flex; flex-wrap: wrap; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr>
                        <td style="width: 40%; text-align: left">
                            <span><?php echo e(mb_strtoupper($school->school->name_school)); ?></span>
                        </td>
                        <td style="width: 30%; text-align: center">
                            <span>©<?php echo e($cutting->schoolYear->school_year); ?></span>
                        </td>
                        <td style="width: 30%; text-align: right">
                            <span><?php echo e($school->address_email); ?> / <?php echo e($school->phon_school); ?></span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </footer>
</body>
</html><?php /**PATH C:\Users\EDUCAS\Desktop\AppS\V4_001\resources\views/pdf/program_devoir.blade.php ENDPATH**/ ?>