<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="Educas est une application de gestion d'ecole dans son ensemble">
    <meta name="author" content="Jean-Marius Yao">
    <title>Liste de classe {{$class->libelle}}</title>
</head>
<style>
    body {
        font-size: .875em;
        overflow-x: hidden;
        color: #353c4e;
        font-family: "Open Sans", sans-serif;
    }

    /* applies border to the table */
    #tabled,th,td {
        border: 1px solid #dee2e6;
        padding: 10px;
        text-align: center
    }

    #tabled {
        width: 100%;
        border: 1px solid #dee2e6;
        border-collapse: collapse;
        table-layout: auto;
        border-spacing: 2px;
    }

    th, td {
        white-space: nowrap;
    }
</style>
<body>
    <header style="margin: 5px auto; border-bottom: 1px solid #dee2e6; height: 100px; padding-bottom: 15px">
        <div style="display: flex; flex-direction: row; justify-content: space-between;">
            <table style="width: 100%">
                <tbody>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px">Ministère de l'Education Nationale, de l'Enseignement <br> Technique et de la   Formation Professionnelle</div>
                        </td>
                        <td style="width: 50%; border:none">
                            <div style="text-align: center; font-size: 8px;">
                                <b >REPUBLIQUEDE COTE D'IVOIRE</b><br>
                                <i>Union - Discipline - Travail</i>
                            </div>
                        </td>
                    </tr>
                    <tr style="margin-bottom: 0%">
                        <td style="width: 40%; border:none">
                            <img src="{{public_path($school->logoUrl())}}" class="m-b-10 w-100" alt="Logo établissement" style="height: 55px;">
                        </td>
                        <td style="width: 60%; border:none">
                            <div style="text-align: center">
                                <div style="text-align: center;">
                                    <b style="font-size: 15px;">{{mb_strtoupper($school->school->name_school)}}</b><br>
                                    <i style="font-size: 9px">{{$school->address_email}} / {{$school->phon_school}}</i><br>
                                    <i style="font-size: 11px;">Année Scolaire : <b>{{$class->schoolYear->school_year}}</i>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </header>
    {{-- <hr> --}}
    <section style="margin: 5px auto;">
        <div style="margin-top: 20px">
            <div style="margin-top: 35px; text-align: center; font-size:21px; text-decoration: underline;">
                <b>LISTE DE CLASSE {{$class->libelle}}</b>
            </div>
            <div style="margin-top: 25px; margin-left: 15px; margin-bottom: 0px">
                <span>Effectif : {{count($student) <= 9 ? '0'.count($student):count($student)}}</span>
                <span style="margin: 0px 15px"> | F : {{$nbreF <= 9 ? '0'.$nbreF:$nbreF}}</span>
                <span style="margin: 0px 15px"> | M : {{$nbreM <= 9 ? '0'.$nbreM:$nbreM}}</span>
            </div>
            <table id="tabled" style="margin-top: 0px">
                <thead>
                    <tr>
                        <th style="width: 3%"></th>
                        <th>Matricule</th>
                        <th>Nom et Prenoms</th>
                        <th>Genre</th>
                        {{-- <th>Date de nais...</th> --}}
                        @if (!($class['type'] == 'primaire'))
                        <th>Affecté</th>
                        @endif
                        <th>Redoublant</th>
                        @if (!($class['type'] == 'primaire'))
                        <td>Boursier</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; @endphp
                    @foreach ($student as $item)
                    <tr>
                        <th class="text-center">{{$i <= 9 ? '0'.$i++:$i++}}</th>
                        <td>{{$item->matricule}}</td>
                        <td style="text-align: left">{{mb_strtoupper($item->first_name).' '.ucfirst($item->last_name)}}</td>
                        <td>{{ucfirst($item->sexe == 'F' ? 'F':'M')}}</td>
                        {{-- <td>{{$item->date_birth.' à '.ucfirst($item->place_birth)}}</td> --}}
                        @if ($item->affecte)
                        <td>{{ucfirst($item->affecte)}}</td>
                        @endif
                        <td>{{ucfirst($item->redoublant)}}</td>
                        @if ($item->boursier)
                        <td>{{ucfirst($item->boursier)}}</td>
                        @endif
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </section>
</body>
</html>