<?php

namespace App\Jobs;

use App\Models\MoyenneBilan;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class NonClasseeRangBilanJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $students, $cutting, $school;

    /**
     * Create a new job instance.
     */
    public function __construct($students, $cutting, $school)
    {
        $this->students = $students;
        $this->cutting = $cutting;
        $this->school = $school;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $i = 1;
        while($i < 4){
            $this->updateRang($i);
            $i++;
        }
    }


    private function updateRang($bilan)
    {
        $dts = getClassement($this->getMoyenne($bilan));
        foreach($dts as $item){
            MoyenneBilan::where('inscription_id', $item['id'])->where('libelle_bilan_id', $bilan)->where('cutting_school_year_id', $this->cutting)->where('school_id', $this->school)->update([
                'rang' => $item['rang']
            ]);
        }
    }

    private function getMoyenne($bilan)
    {
        $tableau = [];
        foreach($this->students as $item){
            $tableau[] = [
                'id' => $item['id'],
                'sexe' => $item['sexe'],
                'moyen' => $this->moyenne($item['id'], $bilan)
            ];
        }
        return $tableau;
    }
    

    private function moyenne($item, $bilan)
    {
        $val = MoyenneBilan::where('inscription_id', $item)->where('libelle_bilan_id', $bilan)->where('cutting_school_year_id', $this->cutting)->where('school_id', $this->school)->first();
        return $val['moyenne'] ?? 'nc';
    }
}
