<?php $__env->startSection('title','inscriptions'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Payement</h4>
                                    
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-toggle="modal" data-target="#addModal" title="New Payment"><i class="fas fa-exchange-alt m-0"></i></button>
                                        <a href="<?php echo e(route('payment.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span> 
                                </div>
                            </div>
                            <hr class="mx-3">
                            <div class="card-block pt-0">
                                <div class="row my-3">
                                    <div class="col-12 mb-3">
                                        <div class="col-xl-8 col-md-12 offset-xl-2">
                                            <div class="card user-card-full" style="margin: auto">
                                                <div class="row m-l-0 m-r-0">
                                                    <div class="col-sm-4 user-profile" style="background-color: #6f7888">
                                                        <div class="card-block text-center text-white mt-3">
                                                            <div class="m-b-25 profile-image">
                                                                <?php if($payment->inscription->student->photo): ?>
                                                                <img src="<?php echo e(asset($payment->inscription->student->urlStudent())); ?>" class="img-radius w-50" alt="User-Profile-Image">
                                                                <?php else: ?>
                                                                <img src="<?php echo e(asset($payment->inscription->student->sexe == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')); ?>" class="img-radius w-50" alt="User-Profile-Image">
                                                                <?php endif; ?>
                                                            </div>
                                                            <h5 class="f-w-600"><?php echo e(strtoupper($payment->inscription->student->first_name)); ?></h5>
                                                            <h6 style="font-weight: bold;"><?php echo e(ucwords($payment->inscription->student->last_name)); ?></h6>
                                                            <b class="m-t-10 f-16"><?php echo e($payment->inscription->student->matricule); ?></b>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-8">
                                                        <div class="card-block">
                                                            <div class="m-b-20 p-b-5 b-b-default <?php echo e($payment->inscription->lv2 ? 'd-flex justify-content-between':'text-center'); ?>">
                                                                <h5 class="f-w-700"><?php echo e($payment->inscription->classe->libelle); ?></h5>
                                                                <h6 class="f-w-600"><?php echo e($payment->inscription->lv2 ? 'LV2 : '.ucfirst($payment->inscription->lv2):null); ?></h6>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-sm-6">
                                                                    <p class="m-b-10 f-w-600">Sexe</p>
                                                                    <h6 class="text-muted f-w-400"><?php echo e($payment->inscription->student->sexe == 'F' ? 'Feminin':'masculin'); ?></h6>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <p class="m-b-10 f-w-600">Date et Lieu de naissance</p>
                                                                    <h6 class="text-muted f-w-400">Né le <?php echo e($payment->inscription->student->date_birth.' à '.ucwords($payment->inscription->student->place_birth)); ?></h6>
                                                                </div>
                                                            </div>
                                                            <h6 class="m-b-20 mt-3 p-b-5 b-b-default f-w-600"></h6>
                                                            <div class="row">
                                                                <?php if($payment->inscription->affecte): ?>
                                                                <div class="col-sm-4">
                                                                    <p class="f-w-600">Affecté<?php echo e($payment->inscription->student->sexe == 'F' ? 'e':''); ?></p>
                                                                    <h6 class="text-muted f-w-400"><?php echo e(ucfirst($payment->inscription->affecte)); ?></h6>
                                                                </div> 
                                                                <?php endif; ?>
                                                                <div class="col-sm-4">
                                                                    <p class="f-w-600">Redoublant<?php echo e($payment->inscription->student->sexe == 'F' ? 'e':''); ?></</p>
                                                                    <h6 class="text-muted f-w-400"><?php echo e(ucfirst($payment->inscription->redoublant)); ?></h6>
                                                                </div>
                                                                <?php if($payment->inscription->boursier): ?>
                                                                <div class="col-sm-4">
                                                                    <p class="f-w-600">Boursi<?php echo e($payment->inscription->student->sexe == 'F' ? 'ère':'er'); ?></</p>
                                                                    <h6 class="text-muted f-w-400"><?php echo e(ucfirst($payment->inscription->boursier)); ?></h6>
                                                                </div>
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="mt-3 b-b-default"></div>
                                                            <div class="mt-2 d-flex justify-content-between">
                                                                <span class="text-muted">Niveau : <?php echo e(ucfirst($payment->inscription->level->level)); ?></span>
                                                                <span class="text-muted">Inscris le : <?php echo e(date('d/m/Y', strtotime($payment->inscription->created_at)).' à '.date('H:i', strtotime($payment->inscription->created_at))); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-3">
                                        <div class="card user-widget-card" style="background-color: #828283">
                                            <div class="card-block mt-2">
                                                <i class="feather  card1-icon fas fa-home" style="background-color: #828283"></i>
                                                <?php if($payment->status): ?>
                                                    <span style="font-size: 19px;  font-weight: bold;">Soldé</span>
                                                <?php else: ?>
                                                    <span style="font-size: 19px;  font-weight: bold;"><?php echo e(remaindCalculat($payment->scolaritie->amount->montant, $payment)); ?> FR CFA</span>
                                                <?php endif; ?>
                                                <p style="font-size: 17px;">Scolaritée</p>
                                                <a href="#!" class="more-info" data-toggle="modal" data-target="#scolarityModal" title="Detail"><i class="fas fa-info-circle mx-3"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-3">
                                        <div class="card user-widget-card" style="background-color: #828283">
                                            <div class="card-block mt-2">
                                                <i class="feather card1-icon fas fa-chart-pie" style="background-color: #828283"></i>
                                                <?php if(sizeof($payment->scolarity_fee)): ?>
                                                    <span style="font-size: 19px;  font-weight: bold;">Payer</span>
                                                <?php else: ?>
                                                    <span style="font-size: 19px;  font-weight: bold;"><?php echo e(preg_replace('/\B(?=(\d{3})+(?!\d))/', ' ', $payment->annex_fee->amount->montant)); ?> FR CFA</span>
                                                <?php endif; ?>
                                                <p style="font-size: 17px;">Frais annexe</p>
                                                <a href="#!" class="more-info" title="Detail"><i class="fas fa-info-circle mx-3"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-3">
                                        <div class="card user-widget-card" style="background-color: #828283">
                                            <div class="card-block">
                                                <i class="feather card1-icon fas fa-bus-alt" style="background-color: #828283"></i>
                                                <?php if($infoBus): ?>
                                                    <span style="font-size: 19px;  font-weight: bold;">Autorisé</span>
                                                    <p style="font-size: 17px;">Tous les trimestres</p>
                                                <?php else: ?>
                                                    <span style="font-size: 19px;  font-weight: bold;">Non Autorisé</span>
                                                    <p style="font-size: 17px;">Aucun payement</p>
                                                <?php endif; ?>
                                                <a href="#!" class="more-info" title="Detail"><i class="fas fa-info-circle mx-3"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-3">
                                        <div class="card user-widget-card" style="background-color: #828283">
                                            <div class="card-block">
                                                <i class="feather card1-icon fas fa-coffee" style="background-color: #828283"></i>
                                                <?php if($canteen): ?>
                                                    <span style="font-size: 19px;  font-weight: bold;"><?php echo e($canteen['status'] != '0' ? ($canteen['statut'] == '1' ? 'En Attente':'Autorisé'):'Accès interdit'); ?></span>
                                                    <p style="font-size: 17px;">
                                                        <?php echo e($canteen['number'].' mois - '); ?> <?php echo e($canteen['statut'] == '1' ? 'Début '.$canteen['debut']:'Fin '.$canteen['fin']); ?>

                                                    </p>
                                                <?php else: ?>
                                                <span style="font-size: 19px;  font-weight: bold;">Non Autorisé</span>
                                                <p style="font-size: 17px;">Aucun payement</p>
                                                <?php endif; ?>
                                                <a href="#!" class="more-info" title="Detail"><i class="fas fa-info-circle mx-3"></i></a>
                                            </div>
                                        </div>
                                    </div>                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
            <h5 class="modal-title" id="addModalLongTitle">New Payment</h5>
            <strong style="font-size: 17px"></strong>
        </div>
        <form action="<?php echo e(route('payment.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-body py-3">
                <input type="hidden" name="payment" id="payment" value="<?php echo e($payment->id); ?>">
                <input type="hidden" name="year" value="<?php echo e($annee->id); ?>" id="year">
                <input type="hidden" value="<?php echo e($payment->type); ?>" id="canteen">
                <div class="form-group pt-2">
                    <label for="type" class="form-label">Type de payement<span class="text-danger">*</span> :</label>
                    <select name="type" id="type" class="form-control select2 bg-white">
                        <option value="" class="text-muted">Selection one option</option>
                        <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                        <option value="1" class="text-muted">Bus Elève</option>
                        <?php endif; ?>
                        <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                        <option value="2" class="text-muted">Cantine</option>
                        <?php endif; ?>
                        <?php if(!sizeof($payment->scolarity_fee)): ?>
                        <option value="3" class="text-muted">Frais annexe</option>
                        <?php endif; ?>
                        <?php if(!$payment->status): ?>
                        <option value="4" class="text-muted">Scolarité</option>
                        <?php endif; ?>
                    </select> 
                </div>
                <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                <div  id="transport" style="display: none">
                    <div class="form-group pt-2">
                        <label for="bus" class="form-label">Zone concernée<span class="text-danger">*</span> :</label>
                        <select name="bus" id="bus" class="form-control select2 bg-white">
                            <option value="" class="text-muted">Select ...</option>
                            <?php $__currentLoopData = $transports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id.'_'.$item->montant); ?>" class="text-muted" <?php echo e($infoBus ? ($infoBus['transport_id'] == $item->id ? 'selected':null):null); ?>><?php echo e(ucwords($item->zone)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select> 
                    </div>
                    <div class="form-group pt-2" id="divTours" style="display: none">
                        <label for="bus" class="form-label">Nombre de voyage :</label><br>
                        <span class="mr-2" title="Matin - Soir">
                            <input type="radio" name="tours" id="tours_1" value="1" <?php echo e($infoBus ? ($infoBus['tours'] == 1 ? 'checked':null):'checked'); ?>>
                            <label for="tours_1" class="mx-1">1 voyage</label>
                        </span>
                        <span class="ml-2" title="Matin - Midi - Soir">
                            <input type="radio" name="tours" id="tours_2" value="2" <?php echo e($infoBus ? ($infoBus['tours'] == 2 ? 'checked':null):null); ?>>
                            <label for="tours_2" class="mx-1">2 voyages</label>
                        </span>
                    </div>
                </div>
                <div class="form-group pt-2" id="divCutting" style="display: none">
                    <label for="bus" class="form-label">Decoupage concerné :</label><br>
                    <input type="hidden" id="cutting" value="<?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage)); ?>">
                    <span style="display: <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'trimestre' ? 'block':'none'); ?>">
                        <span class="mr-2">
                            <input type="checkbox" name="trim_1" id="trim_1" <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'trimestre' ? ($infoBus ? ($infoBus['trim_1'] ? 'disabled':'checked'):'checked'):''); ?>>
                            <label for="trim_1" class="mx-1">Trimestre 1</label>
                        </span>
                        <span class="mx-2">
                            <input type="checkbox" name="trim_2" id="trim_2" <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'trimestre' ? ($infoBus ? ($infoBus['trim_2'] ? 'disabled':'checked'):'checked'):''); ?>>
                            <label for="trim_2" class="mx-1">Trimestre 2</label>
                        </span>
                        <span class="ml-2">
                            <input type="checkbox" name="trim_3" id="trim_3" <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'trimestre' ? ($infoBus ? ($infoBus['trim_3'] ? 'disabled':'checked'):'checked'):''); ?>>
                            <label for="trim_3" class="mx-1">Trimestre 3</label>
                        </span>
                    </span>
                    <span style="display: <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'semestre' ? 'block':'none'); ?>">
                        <span class="mr-2">
                            <input type="checkbox" name="semest_1" id="semest_1" <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'semestre' ? ($infoBus ? ($infoBus['semest_1'] ? 'disabled':'checked'):'checked'):''); ?>>
                            <label for="semest_1" class="mx-1">Semestre 1</label>
                        </span>
                        <span class="mx-2">
                            <input type="checkbox" name="semest_2" id="semest_2" <?php echo e(verifyStudentDecoupage($payment->type, $annee->decoupage) == 'semestre' ? ($infoBus ? ($infoBus['semest_2'] ? 'disabled':'checked'):'checked'):''); ?>>
                            <label for="semest_2" class="mx-1">Semestre 2</label>
                        </span>
                    </span>
                </div>
                <?php endif; ?>
                <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                    <div id="divcanteen" style="display: none">
                        <div class="form-group pt-2">
                            <label for="type" class="form-label">Nombre de mois<span class="text-danger">*</span> :</label>
                            <input type="text" id="nbreDay" name="number" class="form-control"  maxlength="1" placeholder="Entrez le nombre de mois ...">
                            <span class="text-danger" style="display: none" id="spanCanteen">Montant non definit !</span>
                        </div>
                        <div class="form-group">
                            <label for="delai" class="form-label">A compter de ce mois</label>
                            <input type="checkbox" id="delai" name="delai" class="ml-2">
                        </div>
                        <input type="hidden" id="montants" value="" style="display: none">
                    </div>
                <?php endif; ?>
                <div class="form-group pt-2" id="divAPayer" style="display: none">
                    <label class="form-label">Net à payer : <strong class="mx-2" id="aPayer"></strong>FR CFA</label>
                </div>
                <div class="form-group pt-2" id="divAmount" style="display: none">
                    <label for="amount" class="form-label">Montant<span class="text-danger">*</span> :</label>
                    <input type="text" id="amount" name="amount" class="form-control" placeholder="Entrez le montant ..." required>
                    <span class="m-1 text-danger" id="InfoText"></span>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</a>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="addBtn">Valider</button>
            </div>
        </form>
    </div>
  </div>
</div>

<!-- @Modal  List Scolarite-->
<div class="modal fade" id="scolarityModal" tabindex="-1" role="dialog" aria-labelledby="scolarityModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="scolarityModalTitle">Liste des payements</h5>
          <span id="libelle" style="font-size: 18px">Scolarité</span>
        </div>
        <div class="modal-body">
            <div class="dt-responsive table-responsive">
                <table id="modalEnseignant" class="table table-striped table-bordered nowrap">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 5%">N°</th>
                            <th class="text-center" style="width: 100px">Date</th>
                            <th class="text-center" style="width: 100px">Amount</th>
                            <th class="text-center" style="width: 70px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php $__empty_1 = true; $__currentLoopData = $payment->payment_scolarities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                            <td><?php echo e(date('d/m/Y', strtotime($item->created_at)).' à '.date('H:i', strtotime($item->created_at))); ?></td>
                            <td><?php echo e(formatMontant($item->amount) ?? '00'); ?> FR CFA</td>
                            <td class="py-1">
                                <div class="card-block remove-label m-0 p-0 text-center">
                                    <a href="#" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-list-ul m-0"></i></a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <th colspan="4" class="text-center">Aucun payement éffectué !</th>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
          <a href="#" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" id="formUrl">Imprim</a>
        </div>
      </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
      
            $('#type').on('change', function() {
                let val = $(this).val();
                if($(this).val() && ['3', '4'].includes($(this).val())){
                    $.ajax({
                        url: '<?php echo e(route('payment.search')); ?>',
                        method: 'GET',
                        data: { 
                            id: $('#payment').val(),
                            val: $(this).val()
                        },
                        success: function(response){
                            if(response){
                                $('#amount').prop('disabled', val == 3 ? true:false);
                                $('#amount').val(response.replace(/\B(?=(\d{3})+(?!\d))/g, ' '));
                                $('#divAmount').fadeIn(1000);
                                val == 3 ? $('#InfoText').text('Payer une seule fois l\'apprennant !'):$('#InfoText').text('');
                            }
                            else{
                                $('#amount').val();
                                $('#divAmount, #divAmount').fadeOut(1000);
                            }
                        }
                    });
                }
                else{
                    $('#amount').val();
                    $('#divAmount, #transport, #divcanteen, #spanCanteen').fadeOut(1000);
                    if($(this).val() == 1){
                        $('#transport').fadeIn(1000);
                        if($('#bus').val()){
                            $val = $('#bus').val().split("_");
                            $cutting = $('input[type="checkbox"]:checked').length;
                            $tours = $('input[name="tours"]:checked').val();
                            $vals = $val[1]*$cutting*$tours;
                            $('#divCutting, #divTours').fadeIn(1000);
                            getAmount($vals);
                        }
                    }
                    else{
                        $('#divcanteen').fadeIn(1000);
                        $.ajax({
                            url: '<?php echo e(route('canteen.search')); ?>',
                            method: 'GET',
                            data: { 
                                type: $('#canteen').val(),
                                year: $('#year').val()
                            },
                            success: function(response){
                                if(response){
                                    $('#montants').val(response);
                                    $('#spanCanteen').fadeOut(1000);
                                }
                                else{
                                    $('#montants').val(0);
                                    $('#spanCanteen').fadeIn(1000);
                                }
                                
                            }
                        });
                    }
                }
            });


            $('#bus').on('change', function() {
                if( $(this).val()){
                    $val = $(this).val().split("_");
                    $cutting = $('input[type="checkbox"]:checked').length;
                    $('#divCutting, #divTours').fadeIn(1000);
                    getAmount($val[1]*$cutting); //
                }
                else{
                    $('#divCutting, #divTours, #divAmount').fadeOut(1000);
                }
            });


            $('input[name="tours"]').on('click', function() {
                $val = $('#bus').val().split("_");
                $cutting = $('input[type="checkbox"]:checked').length;
                $vals = $val[1]*$cutting*$(this).val();
                getAmount($vals); //
            });


            $($('input[type="checkbox"]:checked')).on('click', function() {
                $cutting = $('input[type="checkbox"]:checked').length;
                $val = $('#bus').val().split("_");
                $tours = $('input[name="tours"]:checked').val();
                $vals = $val[1]*$cutting*$tours;
                getAmount($vals); //
            });



            $('#nbreDay').on('input', function() {
                if($(this).val() && $('#montants').val()){
                    $('#divAPayer').fadeIn(1000);
                    $total = $(this).val() * $('#montants').val();
                    $('#aPayer').text(formatVal($total));
                    $('#amount').val($total);
                }
                else{
                    $('#divAPayer').fadeOut(1000);
                }
            });



            $('#amount').on('input', function() {
                let valeur = $(this).val(); // Récupère la valeur du champ
                if(valeur){
                    $.ajax({
                        url: '<?php echo e(route('payment.verify')); ?>',
                        method: 'GET',
                        data: { 
                            id: $('#payment').val(),
                            val: $(this).val()
                        },
                        success: function(response){
                            if(!response){
                                $('#InfoText').text('Montant élévé pour ce qu\'il faut payer !');
                            }
                        }
                    })
                }
            });



            $('#amount, #nbreDay').on('input', function () {
                let value = $(this).val().replace(/\s/g, '');
                value = value.replace(/\D/g, '');
                let formatted = value.replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
                $(this).val(formatted);
            });



            function formatVal($val){
                return $val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
            }


            function getAmount($vals){
                $('#aPayer').text(formatVal($vals));
                $('#amount').val($vals);
                $('#divAPayer').fadeIn(1000);
                $('#addBtn').prop('disabled', $vals ? false:true);
            }

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/payment/detail.blade.php ENDPATH**/ ?>