<?php $__env->startSection('title', 'Gestion des appels'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des <?php echo e($cndte->matter->libelle); ?></h4>
                                    <p class="m-0" style="font-size: 17px"><strong><?php echo e($classe['libelle']); ?></strong></p>
                                    <div class="right">
                                        <span style="float: right">
                                            <button type="button" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mr-1" id="modalBtn" data-toggle="modal" data-target="#getModal" title="Approuvé"><i class="fas fa-thumbs-up mx-0"></i></button>
                                            <a href="<?php echo e(route('sanction.show', $classe->id)); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 ml-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e($item['actif'] == 1 ? 'active':''); ?> menuStep" data-lib="<?php echo e($item['libelle']); ?>" id="<?php echo e($item['actif'] == 1 ? 'active':'inactif'); ?>" data-actif="<?php echo e($item['actif']); ?>" data-id="<?php echo e($item['id']); ?>" data-approved="<?php echo e($item['approved']); ?>" data-toggle="tab" href="#home<?php echo e($item['id']); ?>" role="tab" aria-selected="true">
                                               <?php echo e(ucfirst($item['libelle'])); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e($item['actif'] == 1 ? 'active':''); ?>" id="home<?php echo e($item['id']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tab']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 3%">N°</th>
                                                        <th class="text-center" style="width: 25%">Nom & Prenoms</th>
                                                        <th class="text-center" style="width: 9%">Sexe</th>
                                                        <th class="text-center" style="width: 10%">Matricule</th>
                                                        <th class="text-center" style="width: 10%">Assiduité</th>
                                                        <th class="text-center" style="width: 10%">Discipline</th>
                                                        <th class="text-center" style="width: 10%">Moralite</th>
                                                        <th class="text-center" style="width: 10%">Tenue</th>
                                                        <th class="text-center" style="width: 8%">Moyenne</th>
                                                        <th class="text-center" style="width: 5%">Rang</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="px-3"><?php echo e($val['name']); ?> <strong class="text-danger" style="display: <?php echo e($val['conseil'] ? 'online':'none'); ?>">*</strong></td>
                                                        <td class="text-center"><?php echo e($val['sexe']); ?></td>
                                                        <td class="text-center"><?php echo e($val['matricule']); ?></td>
                                                        <td class="text-center"><?php echo e($val['assiduite'] <= 9 ? '0'.$val['assiduite']:$val['assiduite']); ?></td>
                                                        <td class="text-center"><?php echo e($val['discipline'] <= 9 ? '0'.$val['discipline']:$val['discipline']); ?></td>
                                                        <td class="text-center"><?php echo e($val['moralite'] <= 9 ? '0'.$val['moralite']:$val['moralite']); ?></td>
                                                        <td class="text-center"><?php echo e($val['tenue'] <= 9 ? '0'.$val['tenue']:$val['tenue']); ?></td>
                                                        <td class="text-center"><?php echo e($val['moyen']); ?></td>
                                                        <td class="text-center"><?php echo e($val['rang']); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="getModal" tabindex="-1" role="dialog" aria-labelledby="getModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="getModalLongTitle">Moyenne Conduite</h5>
            </div>
            <form action="<?php echo e(route('conduite.store')); ?>" method="post" id="formEvaluats">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <p class="text-center">Validation des moyennes de conduites</p>
                    <div class="text-center" style="font-weight: 800;" id="libelle"></div>
                    <input type="hidden" name="classe" value="<?php echo e($classe->id); ?>">
                    <input type="hidden" name="cutting" value="" id="cutting">
                    <input type="hidden" name="matter" value="<?php echo e($cndte->id); ?>">
                </div>
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            $('.dataTables_length').append('<span class="my-0 mx-2"><strong class="text-danger">*</strong> Elève traduit en conseil de discipline !</span>');

            $val = $('#active').data('id');
            $('#active').data('approved') ? $('#modalBtn').css('visibility', 'hidden'):$('#modalBtn').css('visibility', 'visible');
            $('#cutting').val($val);
            $('.nav-link').on('click', function(){
                $val = $(this).data('id');
                $('#cutting').val($val);
                $(this).data('approved') ? $('#modalBtn').css('visibility', 'hidden'):$('#modalBtn').css('visibility', 'visible');
            });

            $('#modalBtn').on('click', function() {
                $val = $('#cutting').val();
                if($val){
                    $.ajax({
                        url: '<?php echo e(route('conduite.search')); ?>',
                        method: 'GET',
                        data: {
                            id: $val
                        },
                        success: function(data){
                            $('#libelle').text(data);
                        }
                    });
                }
            })
            
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/conduite/index.blade.php ENDPATH**/ ?>