<?php $__env->startSection('title','inscriptions'); ?>
<?php $__env->startSection('link'); ?>
    <!-- Data Table Css -->
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/autoFill.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/extensions/autofill/css/select.dataTables.min.css')); ?>">
    <style>
        .dataTables_length label{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Gestion des payements</h4>
                                    <span class="mx-2">
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-2" data-toggle="modal" data-target="#modalCenter" title="Amount of the day"><i class="fas fa-chess-board m-0"></i></button>
                                        <a href="<?php echo e(route('payment.detail')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-2" title="Détail"><i class="fas fa-box-open mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <hr class="mx-3 my-0">
                            <div class="card-block pt-0">
                                <div class="dt-responsive table-responsive">
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <div class="tab-pane active" id="home7" role="tabpanel">
                                            <table id="autofill" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="width: 5%">N°</th>
                                                        <th class="text-center" style="width: 10%">Matricule</th>
                                                        <th class="text-center" style="width: 15%">Nom</th>
                                                        <th class="text-center" style="width: 25%">Prénoms</th>
                                                        <th class="text-center" style="width: 10%">Genre</th>
                                                        <th class="text-center" style="width: 15%">Status</th>
                                                        <th class="text-center" style="width: 15%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td><?php echo e($item->inscription->student->matricule); ?></td>
                                                        <td><?php echo e(ucwords($item->inscription->student->first_name)); ?></td>
                                                        <td><?php echo e(ucwords($item->inscription->student->last_name)); ?></td>
                                                        <td><?php echo e($item->inscription->student->sexe == 'F' ? 'Feminin':'masculin'); ?></td>
                                                        <td class="text-center">
                                                            <?php if($item->status == 1 ): ?>
                                                                <span class="pcoded-badge label label-success fw-bold"><strong>Soldé</strong></span>
                                                            <?php else: ?>
                                                                <span class="pcoded-badge label label-<?php echo e(determined($item->scolaritie->amount->montant, $item)); ?>">
                                                                    <strong><?php echo e(remaindCalculat($item->scolaritie->amount->montant, $item)); ?> FR CFA</strong>
                                                                </span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <a href="<?php echo e(route('payment.show',$item->id)); ?>" class="btn btn-sm btn-primary text-center px-2" title="Detail"><i class="fas fa-list-ul m-0"></i></a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- @Modal -->
<div class="modal fade" id="modalCenter" tabindex="-1" role="dialog" aria-labelledby="modalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
    <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="scolarityModalTitle">Récap To Day</h5>
          <span id="libelle" style="font-size: 18px"><?php echo e(date('d-m-Y')); ?></span>
        </div>
      <div class="modal-body">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th scope="col">Scolarité</th>
                        <th scope="col">Frais annexe</th>
                        <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                        <th scope="col">Bus</th>
                        <?php endif; ?>
                        <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                        <th scope="col">Cantine</th>  
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e(formatMontant($scolarity) ?? '00'); ?> FR CFA</td>
                        <td><?php echo e(formatMontant($annexFee) ?? '00'); ?> FR CFA</td>
                        <?php if(VerifyBox(auth()->user()->school->setting, 'transport')): ?>
                        <td><?php echo e(formatMontant($transport) ?? '00'); ?> FR CFA</td>
                        <?php endif; ?>
                        <?php if(VerifyBox(auth()->user()->school->setting, 'canteen')): ?>
                        <td><?php echo e(formatMontant($canteen) ?? '00'); ?> FR CFA</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <th colspan="4">
                            <div class="text-right mx-2" style="font-size: 16px">
                                Total : <?php echo e(formatMontant($scolarity+$annexFee+$transport+$canteen) ?? '00'); ?> FR CFA
                            </div>
                        </th>
                    </tr>
                </tbody>
            </table>
        </div>
      <div class="modal-footer" style="border: none">
        <button type="button" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/extensions-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            $('#autofill_length').append('<strong class="mx-3" style="font-size: 17px"><?php echo e($year->school_year); ?></strong>')

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/payment/index.blade.php ENDPATH**/ ?>