<?php $__env->startSection('title', 'Evaluation par matière'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }

    .highcharts-credits{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <h4>Détail Résultat</h4>
                                    <span class="form-control-variant" style="font-size: 15px">
                                        <strong class="mr-2"><?php echo e($classe['libelle']); ?></strong>[<?php echo e($enseignant ? :'Non defini'); ?>]
                                    </span>
                                    <span>
                                        <a id="btnLink" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Vus d'ensemble"><i class="far fa-eye m-0"></i></a>
                                        <a href="<?php echo e(route('resultat.index')); ?>" class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" title="Return Back"><i class="fas fa-reply mx-0"></i></a>
                                    </span>
                                </div>
                            </div>
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e($item['actif'] == 1 ? 'active':''); ?>" data-lib="<?php echo e($item['libelle']); ?>" id="<?php echo e($item['actif'] == 1 ? 'active':'inactif'); ?>" data-actif="<?php echo e($item['actif']); ?>" data-id="<?php echo e($item['id']); ?>" data-toggle="tab" href="#home<?php echo e($item['id']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?>

                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e($item['actif'] == 1 ? 'active':''); ?>" id="home<?php echo e($item['id']); ?>" role="tabpanel">
                                            <div class="row">
                                                <?php if($item['data']): ?>
                                                <div class="col-xl-6 col-md-12">
                                                    <div class="card" style="height: 450px">
                                                        <div class="card-header">
                                                            <strong style="font-size: 17px">Les Trois Meilleurs</strong>
                                                            <hr class="my-1">
                                                        </div>
                                                        <div class="card-block" style="height: 230px">
                                                            <?php $__currentLoopData = $item['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="row m-b-25">
                                                                <div class="col-auto p-r-0">
                                                                    <?php if($student['photo']): ?>
                                                                    <img src="<?php echo e(asset('storage/'.$student['photo'])); ?>" alt="Photo" alt="" class="img-fluid img-50">
                                                                    <?php else: ?>
                                                                    <img src="<?php echo e(asset($student['sexe'] == 'F' ? 'assets/images/stdt_w.png':'assets/images/stdt_m.png')); ?>" alt="" class="img-fluid img-50">
                                                                    <?php endif; ?>
                                                                </div>
                                                                <div class="col">
                                                                    <h6 class="m-b-5" style="font-weight: bold;"><?php echo e(strtoupper($student['first_name']).' '.ucwords($student['last_name'])); ?></h6>
                                                                    <p class="text-muted m-b-0"><strong><?php echo e($student['rang']); ?></strong> - <strong><?php echo e($student['moyenne']); ?></strong> de moyenne.</p>
                                                                </div>
                                                            </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                        <div class="card-footer">
                                                            <div class="row text-center b-t-default">
                                                                <div class="col-6 b-r-default m-t-15">
                                                                    <h5>
                                                                        <strong><?php echo e($item['resultat']['moyenne'] ? $item['resultat']['moyenne'].'/20':null); ?></strong>
                                                                    </h5>
                                                                    <p class="text-muted m-b-0">Moyenne de Classe</p>
                                                                </div>
                                                                <div class="col-6 m-t-15">
                                                                    <h5>
                                                                        <strong><?php echo e($item['plus']  ? $item['plus']:'00'); ?>%</strong>
                                                                    </h5>
                                                                    <p class="text-muted m-b-0">Taux De Réussite</p>
                                                                </div>
                                                            </div>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-6 col-md-6">
                                                    <div class="card" style="height: 450px">
                                                        <div class="card-block" style="height: 230px">
                                                            <div id="container_<?php echo e($item['id']); ?>" data-ttls="<?php echo e($classe['inscrits']); ?>" data-sup="<?php echo e($item['resultat']['nbre_superieur'] ? round(($item['resultat']['nbre_superieur'] / $classe['inscrits'])*100):'0'); ?>" data-ent="<?php echo e($item['resultat']['nbre_entre'] ? round(( $item['resultat']['nbre_entre'] / $classe['inscrits'])*100):'0'); ?>" data-inf="<?php echo e($item['resultat']['nbre_inferieur'] ? round(($item['resultat']['nbre_inferieur'] / $classe['inscrits'])*100):'0'); ?>"  class="my-0"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php else: ?>
                                                <div class="col-12">
                                                    <div class="card-block text-center">
                                                        <p class="pt-5 mt-5">Informations Non Disponibles</p>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- data-table js -->
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

    <!-- Chart js -->
    <script src="https://code.highcharts.com/highcharts.js"></script>

    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>

    <script>
        $(document).ready(function(){
            
            var currentUrl = window.location.href;
            let debutUrl = currentUrl.split("resultat");

            $content = 'container_'+($("#active").data('id') ?? <?php echo e($datas[0]['id']); ?>);
            $sups = $('#'+$content).data('sup'); $ents = $('#'+$content).data('ent'); $infs = $('#'+$content).data('inf'); $tls = $('#'+$content).data('ttls');
            if($content){
                charts($content, $tls, $sups, $infs, $ents);
            }

            // alert($content);
            $('#btnLink').attr('href', debutUrl[0]+'resultat/list/'+<?php echo e($classe->id); ?>+'_'+$("#active").data('id'));
            $('.nav-link').on('click', function(){
               
                $('#btnLink').attr('href', debutUrl[0]+'resultat/list/'+<?php echo e($classe->id); ?>+'_'+$(this).data('id'));

                $content = 'container_'+$(this).data('id');
                $sups = $('#'+$content).data('sup'); $ents = $('#'+$content).data('ent'); $infs = $('#'+$content).data('inf'); $tls = $('#'+$content).data('ttls');
                if($content){
                    charts($content, $tls, $sups, $infs, $ents);
                }
            });

            
            
            // ------------------------------------------------------------------------------------
            // Data retrieved from https://netmarketshare.com/   ||||   https://www.highcharts.com/demo/highcharts/pie-chart
            function charts($id, $tls, $sup, $inf, $ent){
                Highcharts.chart($id, {
                    chart: {
                        type: 'pie',
                        custom: {},
                        events: {
                            render() {
                                const chart = this,
                                    series = chart.series[0];
                                let customLabel = chart.options.chart.custom.label;

                                if (!customLabel) {
                                    customLabel = chart.options.chart.custom.label =
                                    chart.renderer.label('Total : <br/>' + '<strong>'+$tls+'</strong>')
                                    .css({
                                        color: 'var(--highcharts-neutral-color-100, #000)',
                                        textAnchor: 'middle'
                                    })
                                    .add();
                                }

                                const x = series.center[0] + chart.plotLeft,
                                    y = series.center[1] + chart.plotTop -
                                    (customLabel.attr('height') / 2);

                                customLabel.attr({
                                    x,
                                    y
                                });
                                // Set font size based on chart diameter
                                customLabel.css({
                                    fontSize: `${series.center[2] / 12}px`
                                });
                            }
                        }
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    title: {
                        text: 'Statistique De La Classe'
                    },
                    subtitle: {
                        text: 'Pourcentage Des Marges'
                    },
                    tooltip: {
                        pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>'
                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            borderRadius: 8,
                            dataLabels: [{
                                enabled: true,
                                distance: 20,
                                format: '{point.name}'
                            }, {
                                enabled: true,
                                distance: -15,
                                format: '{point.percentage:.0f}%',
                                style: {
                                    fontSize: '0.9em'
                                }
                            }],
                            showInLegend: true
                        }
                    },
                    series: [{
                        name: 'Résultat ',
                        colorByPoint: true,
                        innerSize: '60%',
                        data: [
                            {
                                name: 'Supérieur ou egale à 10',
                                y: $sup,
                                color: '#42dfb7'
                            },
                            {
                                name: 'Comprise entre 8.5 et 9.99',
                                y: $ent,
                                color: '#3eacce'
                            },
                            {
                                name: 'Inférieur à 8.5',
                                y: $inf,
                            color: '#fa7945'
                            }
                        ]
                    }]
                });
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/resultats/detail.blade.php ENDPATH**/ ?>