
<?php $__env->startSection('title', 'Program Devoir'); ?>
<?php $__env->startSection('link'); ?>
<!-- Data Table Css -->
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/pages/data-table/css/buttons.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<style>
    .dataTables_length label{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="pcoded-inner-content">
    <?php echo $__env->make('includes._alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-body">
        <div class="page-wrapper">
            <div class="page-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header mb-0 pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4>Liste Des Devoirs</h4>
                                    <span>
                                        <button class="btn btn-inverse btn-outline-inverse  btn-sm py-1 mx-1" id="getAdd" title="New Devoir" data-toggle="modal" data-target="#addModal" style="display: none"><i class="fas fa-plus mx-0"></i></button>
                                    </span>
                                </div>
                            </div>
                            <hr class="my-0 mx-3">
                            <div class="card-block">
                                <div class="dt-responsive table-responsive">
                                    <ul class="nav nav-tabs md-tabs" role="tablist">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item" style="width: 18%">
                                            <a class="nav-link text-left <?php echo e($item['actif'] == 1 ? 'active':''); ?>" data-lib="<?php echo e($item['libelle']); ?>" id="<?php echo e($item['actif'] == 1 ? 'active':'inactif'); ?>" data-actif="<?php echo e($item['actif']); ?>" data-id="<?php echo e($item['id']); ?>" data-toggle="tab" href="#home<?php echo e($item['id']); ?>" role="tab" aria-selected="true">
                                                <i class="icofont icofont-home"></i><?php echo e(ucfirst($item['libelle'])); ?> [<?php echo e(count($item['datas']) <= 9 ? '0'.count($item['datas']):count($item['datas'])); ?>]
                                            </a>
                                            <div class="slide" style="width: 16%"></div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <!-- Tab panes -->
                                    <div class="tab-content card-block">
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tab-pane <?php echo e($item['actif'] == 1 ? 'active':''); ?>" id="home<?php echo e($item['id']); ?>" role="tabpanel">
                                            <table id="<?php echo e($item['tableId']); ?>" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 5%"></th>
                                                        <th class="text-center">Matière</th>
                                                        <th class="text-center">Classe</th>
                                                        <th class="text-center">Date</th>
                                                        <th class="text-center">Heure</th>
                                                        <th class="text-center" style="width: 20%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $i = 1; ?>
                                                    <?php $__currentLoopData = $item['datas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <th class="text-center"><?php echo e($i <= 9 ? '0'.$i++:$i++); ?></th>
                                                        <td class="text-center"><?php echo e(ucfirst($val->matter->abbreviated != "All/Esp" ? $val->matter->abbreviated:'LV2')); ?></td>
                                                        <td class="text-center"><?php echo e(ucfirst($val->classe->libelle)); ?></td>
                                                        <td class="text-center"><?php echo e(date('d/m/Y', strtotime($val['date']))); ?></td>
                                                        <td class="text-center"><?php echo e($val['debut']. ' à '.$val['fins']); ?></td>
                                                        <td style="width: 20%" class="py-1">
                                                            <div class="card-block remove-label m-0 p-0 text-center">
                                                                <button class="btn btn-sm btn-info text-center px-2 ml-2 getEdit" data-id="<?php echo e($val['id']); ?>" title="Edit Devoir"><i class="fas fa-edit m-0"></i></a>
                                                                <button class="btn btn-sm btn-danger text-center px-2 ml-2 getDelet" title="Delete Devoir" data-id="<?php echo e($val['id']); ?>"><i class="far fa-trash-alt m-0"></i></button>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Create Devoir -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header bg-dark py-2">
          <h5 class="modal-title" id="addModalLongTitle">New Devoir</h5>
        </div>
        <form action="<?php echo e(route('program.create')); ?>" method="get">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="cutting" id="getInput" value="">
            <div class="modal-body">
                <div class="mb-3">
                    <label for="submatter">Niveau<span class="text-danger">*</span> : </label>
                    <select name="level" class="form-control" id="level">
                        <option value=" ">Select option</option>
                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($level['id']); ?>"><?php echo e(ucwords($level['code'])); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3" id="divClass" style="display: none">
                    <label for="select">Classe<span class="text-danger">*</span> : </label>
                    <select name="classe" class="form-control" id="classes">
                        <!-- Add Classe -->
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
        </form>
      </div>
    </div>
</div>
<!-- Modal Edit Devoir -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="<?php echo e(route('program.update')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-header bg-dark py-2">
                    <h5 class="modal-title" id="editModalLabel">Edit Devoir</h5>
                    <strong id="classEdit" style="font-size: 18px"></strong>
                </div>
                <div class="modal-body">
                    <p style="font-size: 18px">
                        Matière : <strong id="libEdit"></strong>
                    </p>
                    <div class="mb-3">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="dateEdit">Date du devoir<span class="text-danger">*</span> : </label>
                                    <input type="date" name="date" class="form-control" id="dateEdit">
                                </div>
                            </div>
                            <div class="col-6">
                                <label >Période<span class="text-danger">*</span> : </label>
                                <div class="form-group">
                                    <div class="radio-inline mt-2">
                                        <label>
                                            <input type="radio" name="period" value="1" id="debutEdit">
                                            <i class="helper"></i>Matin
                                        </label>
                                    </div>
                                    <div class="radio-inline mt-2">
                                        <label>
                                            <input type="radio" name="period" value="2" id="finEdit">
                                            <i class="helper"></i>Après midi
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-0">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="submatter">Heure debut<span class="text-danger">*</span> : </label>
                                    <input type="time" name="debut" class="form-control" id="heurDebut">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="submatter">Heure fin<span class="text-danger">*</span> : </label>
                                    <input type="time" name="fin" class="form-control" id="heurFin">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="id" id="edit">
                <div class="modal-footer">
                    <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Modal Delete Devoir -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-dark py-2">
                <h5 class="modal-title" id="deleteModalLabel">Delete Devoir</h5>
                <strong id="abreg" style="font-size: 18px"></strong>
            </div>
            <div class="modal-body text-center pb-1">
                <h4 style="font-weight: bold" id="libClass"></h5>
                <strong id="libMatter" style="font-size: 17px"></strong>
                <p> Programé pour le <strong id="dates"></strong>  à <strong id="heur"></strong></p>
                <p class="mb-0">Confirmez la suppression.</p>
            </div>
            <form action="<?php echo e(route('program.delete')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" id="delete">
            <div class="modal-footer">
                <button class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2" data-dismiss="modal">Annuler</button>
                <button type="submit" class="btn btn-inverse btn-outline-inverse btn-sm py-1 mx-2">Valider</button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('bower_components/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/autofill/js/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/pages/data-table/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('bower_components/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Custom js -->
    <script src="<?php echo e(asset('assets/pages/data-table/extensions/colreorder/js/colreorder-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vartical-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            // Default Infomation
            $actif = $("#active").data('actif');
            ($actif && $actif != 2) ? $('#getAdd').slideDown():$('#getAdd').slideUp();
            $('#getInput').val($('#active').data('id'));


            $('.nav-link').on('click', function(){
                $actif = $(this).data('actif');
                $actif == 2 ? $('#getAdd').hide():$('#getAdd').slideDown();
                $('#getInput').val($actif == 2 ? null:$(this).data('id'));
            });


            $('#level').on('change', function() {
                $class = $('input[name="radio"]:checked').val();
                $('.option').remove();
                if($class != 0){
                    $('#divClass').show();
                    $.ajax({
                        url: '<?php echo e(route('program.class')); ?>',
                        method: 'GET',
                        data: {
                            id: $(this).val()
                        },
                        success: function(data){
                            if(data.status == 200){
                                $data = data.data;
                                $i = 0; 
                                while ($i < $data.length) {
                                    $('#classes').append('<option value="'+$data[$i].id+'" class="option">'+$data[$i].libelle+'</option>');
                                    $i++;
                                }
                            }
                            else{
                                $('#classes').append('<option class="option" value=" ">Classe non disponible</option>');
                            }
                        }
                    }); 
                }
                else{
                    $('#classes').val('');
                    $('#divClass').hide();
                }
            });


            $('.getEdit').on('click', function() {
                if($(this).data('id')){
                    $('#edit').val($(this).data('id'));
                    $.ajax({
                        url: '<?php echo e(route('program.edit')); ?>',
                        method: 'GET',
                        data: {
                            id: $(this).data('id')
                        },
                        success: function(data){
                            if(data.status == 200){
                                $('#classEdit').text(data.data.classe);
                                $('#libEdit').text(data.data.matter);
                                $('#dateEdit').val(data.data.edit);
                                $('#heurDebut').val(data.data.debut);
                                $('#heurFin').val(data.data.fin);
                                data.data.period == 1 ? 
                                $('#debutEdit').prop('checked', true):
                                $('#finEdit').prop('checked', true);
                            }
                            const editModal = new bootstrap.Modal(document.getElementById('editModal'));
                            editModal.show();
                        }
                    }); 
                }
            });


            $('.getDelet').on('click', function() {
                if($(this).data('id')){
                    $('#delete').val($(this).data('id'));
                    $.ajax({
                        url: '<?php echo e(route('program.edit')); ?>',
                        method: 'GET',
                        data: {
                            id: $(this).data('id')
                        },
                        success: function(data){
                            if(data.status == 200){
                                $('#libClass').text(data.data.classe);
                                $('#libMatter').text(data.data.matter);
                                $('#abreg').text(data.data.code);
                                $('#dates').text(data.data.date);
                                $('#heur').text(data.data.debut);
                            }
                            const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                            deleteModal.show();
                        }
                    }); 
                }
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/educasnsa/public_html/neuroschool/resources/views/pages/devoirs/index.blade.php ENDPATH**/ ?>