@extends('auth')
@section('title', 'Login')
@section('content')
<form method="post" action="{{route('login')}}" class="md-float-material form-material">
    @csrf
    <div class="text-center">
        <img src="{{asset('assets/images/logo.png')}}" alt="logo.png">
    </div>
    <div class="auth-box card">
        <div class="card-block">
            <div class="row m-b-20 mb-3">
                <div class="col-md-12">
                    <h3 class="text-center">Page de Connexion</h3>
                </div>
            </div>
            
            @error('email')
                <div class="alert alert-danger background-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="icofont icofont-close-line-circled text-white"></i>
                    </button>
                    <span class="form-bar" role="alert">
                        {{$message}}
                    </span>
                </div>
            @enderror
            <div class="form-group form-primary">
                <label for="email">Adresse mail : </label>
                <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}" placeholder="votre adresse mail">
            </div>
            <div class="form-group form-primary">
                <label for="password">Mot de passe : </label>
                <input type="password" name="password" id="password" class="form-control" placeholder="votre mot de passe">
            </div>
            <div class="row text-left">
                <div class="col-12 d-flex justify-content-between">
                    <div class="checkbox-fades">
                        <label>
                            <input type="checkbox" name="remember_me">
                            <span class="text-inverse">Remember me</span>
                        </label>
                    </div>
                    <div class="forgot-phone text-right f-right">
                        <a href="{{route('password.request')}}" class="text-right f-w-600"> Forgot Password?</a>
                    </div>
                </div>
            </div>
            <div class="row m-t-30">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary btn-md btn-block waves-effect waves-light text-center m-b-20">Sign In</button>
                </div>
            </div>
            <hr />
            <div class="row">
                <div class="col-md-12 text-center">
                    <span class="text-inverse m-b-0">Thank you.</span>
                    <span class="text-inverse"><a href="{{route('login')}}"><b class="f-w-600">Back to website</b></a></span>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection