<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statut_students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('nbre_affect_fille')->default(0);
            $table->integer('nbre_affect_garcon')->default(0);
            $table->integer('nbre_non_affect_fille')->default(0);
            $table->integer('nbre_non_affect_garcon')->default(0);
            $table->unsignedBigInteger('level_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('level_id')->references('id')->on('levels')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statut_students');
    }
};
