<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('evaluated_levels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('ps',[0,1])->default(0);
            $table->enum('ms',[0,1])->default(0);
            $table->enum('gs',[0,1])->default(0);
            $table->enum('cp1',[0,1])->default(0);
            $table->enum('cp2',[0,1])->default(0);
            $table->enum('ce1',[0,1])->default(0);
            $table->enum('ce2',[0,1])->default(0);
            $table->enum('cm1',[0,1])->default(0);
            $table->enum('cm2',[0,1])->default(0);
            $table->unsignedBigInteger('evaluated_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('school_year_id');
            $table->foreign('evaluated_id')->references('id')->on('evaluateds')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_year_id')->references('id')->on('school_years')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evaluated_levels');
    }
};
