<?php

namespace App\Jobs;

use App\Models\MoyenneDecoupageMatiere;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SaveConduiteJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $students;
    protected $class;
    protected $cutting;
    protected $matter;
    /**
     * Create a new job instance.
     */
    public function __construct($students, $class, $cutting, $matter)
    {
        $this->students = $students;
        $this->class = $class;
        $this->cutting = $cutting;
        $this->matter = $matter;
    }


    protected function getSanctions()
    {
        $studts = [];
        foreach($this->students as $item){
            $studts[] = [
                'id' => $item['id'],
                'sexe' => $item['sexe'],
                'moyen' => $item['moyen'],
            ];
        }
        return $studts;
    }


    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $dts = getClassement($this->getSanctions());
        foreach($dts as $item){
            $existe = MoyenneDecoupageMatiere::where('inscription_id', $item['id'])->where('level_matter_id', $this->matter)->where('cutting_school_year_id', $this->cutting)->first();
            if($existe){
                $existe->update(['moyenne' => $item['moyen'], 'rang' => $item['rang']]);
            }
            else{
                MoyenneDecoupageMatiere::create([
                    'inscription_id' => $item['id'],
                    'level_matter_id' => $this->matter,
                    'cutting_school_year_id' => $this->cutting,
                    'moyenne' => $item['moyen'],
                    'rang' => $item['rang']
                ]);
            }
        }
    }
}