<?php $__env->startSection('content'); ?>

<div class="container mt-4">

```
<h3 class="mb-4">Recalcul des moyennes - <?php echo e($trimestre->libelle); ?></h3>

<?php
    // Fonction pour ajouter le suffixe français du rang
    function suffixe_francais($rang) {
        if ($rang == 1) return $rang . 'er';
        return $rang . 'e';
    }
?>

<table class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>Inscription ID</th>
            <th>Matières & Moyennes (coef)</th>
            <th>Moyenne générale</th>
            <th>Rang</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $resultats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eleve): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($eleve['inscription_id']); ?></td>
                <td>
                    <?php if(!empty($eleve['matieres'])): ?>
                        <ul>
                            <?php $__currentLoopData = $eleve['matieres']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matiere): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($matiere['matiere']); ?> (coef: <?php echo e($matiere['coef']); ?>) : <?php echo e($matiere['moyenne']); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        NC
                    <?php endif; ?>
                </td>
                <td><?php echo e($eleve['moyenne_generale'] ?? 'NC'); ?></td>
                <td>
                    <?php if($eleve['rang']): ?>
                        <?php echo e(suffixe_francais($eleve['rang'])); ?>

                    <?php else: ?>
                        NC
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
```

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/educasnsa/public_html/academie/educoach/resources/views/admin/recalcul-moyennes.blade.php ENDPATH**/ ?>