<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>EDUCOACH</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="<?php echo e(asset('lib/animate/animate.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('lib/owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pO1HZ1K9+57cF4U1V3s+u6S3j2zHkJ2t5A4a1cFzX0X+qE2G+vZz1n7aR8T8I3G3YFq+7U3P7s6aKf8VJ0D9BQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />

</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-dark navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="<?php echo e(asset('/')); ?>" class="navbar-brand">
                <h2 class="m-0 text-primary">
                    <img class="flex-shrink-0" src="../img/logo_rochelle.jpg" alt="" style="max-height:100px;">
                <!--<img class="flex-shrink-0" src="img/logo.jpg" alt="" style="width: 150px; height: 80px;">-->
                
                </h2>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="<?php echo e(asset('/')); ?>" class="nav-item nav-link active" style="color: white;">
                        <i class="fas fa-home"></i> Accueil
                    </a>
                    <a href="<?php echo e(route('emploi.du.temps')); ?>" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-calendar-alt me-2"></i> Emploi du Temps
                    </a>
                    <a href="classes.html" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-book"></i> Cours en Ligne
                    </a>
                    <a href="contact.html" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-envelope"></i> Messagerie
                    </a>
                </div>

                <a href="<?php echo e(route('logout')); ?>" class="btn btn-danger">
                                <i class="bi bi-box-arrow-right"></i> Déconnexion
                 </a>
            </div>
        </nav>

        <div class="container-xxl py-5">
            <div class="container">
               
                <div class="row g-4">


<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h3>Notes du <?php echo e($trimestre->libelle); ?></h3>
    <p>
        <strong>Élève :</strong> <?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?> |
        <?php echo e($student->matricule ?? 'Non défini'); ?> |
        <?php echo e($student->currentClass->libelle ?? 'Classe non définie'); ?>

    </p>

    <?php if(empty($notes)): ?>
        <div class="alert alert-warning">Aucune note disponible pour ce trimestre.</div>
    <?php else: ?>

        
<?php
    $classeCouleur = 'alert-info'; // couleur par défaut

    if (is_numeric($moyenne_generale)) {
        if ($moyenne_generale < 10) {
            $classeCouleur = 'alert-danger';   // 🔴 inférieur à 10
        } elseif ($moyenne_generale >= 10 && $moyenne_generale <= 12) {
            $classeCouleur = 'alert-warning';  // 🟠 entre 10 et 12
        } elseif ($moyenne_generale > 12) {
            $classeCouleur = 'alert-success';  // 🟢 supérieur à 12
        }
    }
?>

<div class="alert <?php echo e($classeCouleur); ?> text-center fs-5 mb-4">
    <strong>Moyenne générale :</strong>
    <?php echo e(is_numeric($moyenne_generale) ? number_format($moyenne_generale, 2) : 'NC'); ?>/20
</div>


        <?php $__currentLoopData = $notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matiere => $groupes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card mb-4 shadow-sm">
                <div class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                    <div>
                        <span class="fw-bold"><?php echo e($matiere); ?></span>
                        <span class="badge bg-light text-dark ms-2">
                            Coefficient : <?php echo e($coefficients[$matiere] ?? 1); ?>

                        </span>
                    </div>

                    <?php
    $valeur = $moyennes_matiere[$matiere] ?? null;
    $classeCouleur = 'bg-secondary'; // couleur par défaut (NC)

    if (is_numeric($valeur)) {
        if ($valeur < 10) {
            $classeCouleur = 'bg-danger';   // 🔴 < 10
        } elseif ($valeur >= 10 && $valeur <= 12) {
            $classeCouleur = 'bg-warning';  // 🟠 10 à 12
        } elseif ($valeur > 12) {
            $classeCouleur = 'bg-success';  // 🟢 > 12
        }
    }
?>

<div>
    Moyenne :
    <span class="fw-bold text-white px-2 py-1 rounded <?php echo e($classeCouleur); ?>">
        <?php echo e(is_numeric($valeur) ? number_format($valeur, 2) : 'NC'); ?>/20
    </span>
</div>

                </div>

                <div class="card-body">

                    
                    <?php if(isset($groupes['sous_matieres'])): ?>
                        <?php $__currentLoopData = $groupes['sous_matieres']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_matter_id => $listeSous): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $subName = $listeSous[0]->sous_matiere ?? '-';
                                $moySub = $moyennes_sous_matieres[$matiere][$sub_matter_id] ?? null;
                                $coef = $coeff_sub[$sub_matter_id] ?? 1;
                                $base = 20 * $coef;
                            ?>

                            <h5 class="mt-3 p-2 text-white" style="background-color:#007bff;">
                                <?php echo e($subName); ?> — Moyenne :
                                <span class="fw-bold">
                                    <?php echo e(is_numeric($moySub) ? number_format($moySub,2) : 'NC'); ?>/<?php echo e($base); ?>

                                </span>
                            </h5>

                            <table class="table table-bordered align-middle">
                                <thead class="table-secondary">
                                    <tr>
                                        <th>#</th>
                                        <th>Type d’évaluation</th>
                                        <th>Note</th>
                                        <th>Date d’évaluation</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $listeSous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $type = strtolower($note->evaluation_type);
                                            $base = in_array($type,['interro','interrogation']) ? 10 
                                                  : (in_array($type,['composition','examen']) ? 40 
                                                  : (in_array($type,['devoir','controle','contrôle']) ? 20 : 20));

                                            $dateEval = $note->date_create
                                                ? \Carbon\Carbon::parse($note->date_create)->format('d/m/Y')
                                                : '-';
                                        ?>

                                        <tr>
                                            <td>Note <?php echo e($i+1); ?></td>
                                            <td><?php echo e($note->evaluation_type); ?></td>
                                            <td><?php echo e($note->note); ?>/<?php echo e($note->notee * 20); ?></td>
                                            <td><?php echo e($dateEval); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    
                    <?php if(isset($groupes['principale'])): ?>
                        <table class="table table-bordered align-middle mt-4">
                            <thead class="table-secondary">
                                <tr>
                                    <th>#</th>
                                    <th>Type d’évaluation</th>
                                    <th>Note</th>
                                    <th>Date d’évaluation</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $groupes['principale']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $type = strtolower($note->evaluation_type);
                                        $base = in_array($type,['interro','interrogation']) ? 10 
                                              : (in_array($type,['composition','examen']) ? 40 
                                              : (in_array($type,['devoir','controle','contrôle']) ? 20 : 20));

                                        $dateEval = $note->date_create
                                            ? \Carbon\Carbon::parse($note->date_create)->format('d/m/Y')
                                            : '-';
                                    ?>

                                    <tr>
                                        <td>Note <?php echo e($i+1); ?></td>
                                        <td><?php echo e($note->evaluation_type); ?></td>
                                        <td><?php echo e($note->note); ?>/<?php echo e($note->notee * 20); ?></td>
                                        <td><?php echo e($dateEval); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php endif; ?>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>










</div>
        </div>
        
        <!-- Footer Start -->
        
        <!-- Footer End -->


        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('lib/wow/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/easing/easing.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/waypoints/waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/owlcarousel/owl.carousel.min.js')); ?>"></script>

    <!-- Template Javascript -->
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
</body>

</html>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/educasnsa/public_html/academie/educoach/resources/views/notes/trimestre2.blade.php ENDPATH**/ ?>