<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>EDUCOACH</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="<?php echo e(asset('lib/animate/animate.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('lib/owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pO1HZ1K9+57cF4U1V3s+u6S3j2zHkJ2t5A4a1cFzX0X+qE2G+vZz1n7aR8T8I3G3YFq+7U3P7s6aKf8VJ0D9BQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />

</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-dark navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="<?php echo e(asset('/')); ?>" class="navbar-brand">
                <h2 class="m-0 text-primary">
                    <img class="flex-shrink-0" src="../img/logo_rochelle.jpg" alt="" style="max-height:100px;">
                <!--<img class="flex-shrink-0" src="img/logo.jpg" alt="" style="width: 150px; height: 80px;">-->
                
                </h2>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="<?php echo e(asset('/')); ?>" class="nav-item nav-link active" style="color: white;">
                        <i class="fas fa-home"></i> Accueil
                    </a>
                    <a href="<?php echo e(route('emploi.du.temps')); ?>" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-calendar-alt me-2"></i> Emploi du Temps
                    </a>
                    <a href="classes.html" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-book"></i> Cours en Ligne
                    </a>
                    <a href="contact.html" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-envelope"></i> Messagerie
                    </a>
                </div>

                <a href="<?php echo e(route('logout')); ?>" class="btn btn-danger">
                                <i class="bi bi-box-arrow-right"></i> Déconnexion
                 </a>
            </div>
        </nav>

        <div class="container-xxl py-5">
            <div class="container">
               
                <div class="row g-4">


<?php $__env->startSection('content'); ?>

<div class="container mt-4">

    <h2 class="mb-4 text-center">
        📘 Programme des devoirs — Classe : <?php echo e($class->libelle); ?>

    </h2>
    <p>
        <strong>Élève :</strong> <?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?> |
        <?php echo e(Auth::user()->matricule ?? 'Non défini'); ?> |
        <?php echo e(Auth::user()->currentClass->libelle ?? 'Non définie'); ?>

    </p>

    <?php if($devoirs->isEmpty()): ?>
        <div class="alert alert-info text-center">
            Aucun devoir n'a été planifié pour le moment.
        </div>
    <?php else: ?>

        
        <h4 class="mt-4 mb-2 text-primary">🌅 Devoirs du matin</h4>
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Date</th>
                    <th>Heure</th>
                    <th>Matière</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $devoirs->where('period', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(\Carbon\Carbon::parse($dev->date)->format('d/m/Y')); ?></td>
                        <td><?php echo e($dev->debut); ?> - <?php echo e($dev->fins); ?></td>
                        <td><?php echo e($dev->matiere); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
        <h4 class="mt-4 mb-2 text-primary">🌇 Devoirs de l'après-midi</h4>
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Date</th>
                    <th>Heure</th>
                    <th>Matière</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $devoirs->where('period', 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(\Carbon\Carbon::parse($dev->date)->format('d/m/Y')); ?></td>
                        <td><?php echo e($dev->debut); ?> - <?php echo e($dev->fins); ?></td>
                        <td><?php echo e($dev->matiere); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

    <?php endif; ?>

</div>

<?php $__env->stopSection(); ?>







</div>
        </div>
        
        <!-- Footer Start -->
        
        <!-- Footer End -->


        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('lib/wow/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/easing/easing.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/waypoints/waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/owlcarousel/owl.carousel.min.js')); ?>"></script>

    <!-- Template Javascript -->
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
</body>

</html>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/educasnsa/public_html/academie/educoach/resources/views/devoirs/index.blade.php ENDPATH**/ ?>