<?php $__env->startSection('title', 'Emploi du Temps'); ?>





<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>EDUCOACH</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="<?php echo e(asset('lib/animate/animate.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('lib/owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-pO1HZ1K9+57cF4U1V3s+u6S3j2zHkJ2t5A4a1cFzX0X+qE2G+vZz1n7aR8T8I3G3YFq+7U3P7s6aKf8VJ0D9BQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />

</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-dark navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="<?php echo e(asset('/')); ?>" class="navbar-brand">
                <h2 class="m-0 text-primary">
                    <img class="flex-shrink-0" src="img/logo_rochelle.jpg" alt="" style="max-height:100px;">
                <!--<img class="flex-shrink-0" src="img/logo.jpg" alt="" style="width: 150px; height: 80px;">-->
                
                </h2>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="<?php echo e(asset('/')); ?>" class="nav-item nav-link active" style="color: white;">
                        <i class="fas fa-home"></i> Accueil
                    </a>
                    <a href="<?php echo e(asset('about')); ?>" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-user-times"></i> Absences
                    </a>
                    <a href="<?php echo e(route('notes.trimestre1', ['studentId' => Auth::user()->id])); ?>" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-graduation-cap"></i> Notes et Moyennes
                    </a>
                    <a href="classes.html" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-book"></i> Cours en Ligne
                    </a>
                    <a href="contact.html" class="nav-item nav-link" style="color: white;">
                        <i class="fas fa-envelope"></i> Messagerie
                    </a>
                </div>

                <a href="<?php echo e(route('logout')); ?>" class="btn btn-danger">
                                <i class="bi bi-box-arrow-right"></i> Déconnexion
                 </a>
            </div>
        </nav>

       
        <!-- Navbar End -->


        <!-- Carousel Start 
        <div class="container-fluid p-0 mb-5">
            <div class="owl-carousel header-carousel position-relative">
                <div class="owl-carousel-item position-relative">
                    <img class="img-fluid" src="img/carousel-1.jpg" alt="">
                    <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center" style="background: rgba(0, 0, 0, .2);">
                        <div class="container">
                            <div class="row justify-content-start">
                                <div class="col-10 col-lg-8">
                                    <h1 class="display-2 text-white animated slideInDown mb-4">The Best Kindergarten School For Your Child</h1>
                                    <p class="fs-5 fw-medium text-white mb-4 pb-2">Vero elitr justo clita lorem. Ipsum dolor at sed stet sit diam no. Kasd rebum ipsum et diam justo clita et kasd rebum sea elitr.</p>
                                    <a href="" class="btn btn-primary rounded-pill py-sm-3 px-sm-5 me-3 animated slideInLeft">Learn More</a>
                                    <a href="" class="btn btn-dark rounded-pill py-sm-3 px-sm-5 animated slideInRight">Our Classes</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="owl-carousel-item position-relative">
                    <img class="img-fluid" src="img/carousel-2.jpg" alt="">
                    <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center" style="background: rgba(0, 0, 0, .2);">
                        <div class="container">
                            <div class="row justify-content-start">
                                <div class="col-10 col-lg-8">
                                    <h1 class="display-2 text-white animated slideInDown mb-4">Make A Brighter Future For Your Child</h1>
                                    <p class="fs-5 fw-medium text-white mb-4 pb-2">Vero elitr justo clita lorem. Ipsum dolor at sed stet sit diam no. Kasd rebum ipsum et diam justo clita et kasd rebum sea elitr.</p>
                                    <a href="" class="btn btn-primary rounded-pill py-sm-3 px-sm-5 me-3 animated slideInLeft">Learn More</a>
                                    <a href="" class="btn btn-dark rounded-pill py-sm-3 px-sm-5 animated slideInRight">Our Classes</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        Carousel End -->


        <!-- Page Header End 
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h5 class="display-2 text-white animated slideInDown mb-4">
                    <?php if(Auth::check()): ?>
                    
                         <?php echo e(Auth::user()->school->name_school ?? 'Non définie'); ?>

                    <?php endif; ?>
                </h5>
                
                <div class="d-flex align-items-center">
                    <img class="rounded-circle flex-shrink-0" src="img/user.jpg" alt="" style="width: 100px; height: 100px;">
                    <div class="ms-3">
                        <h4 class="text-white mb-1">
                            

                            <?php if(Auth::check()): ?>
                                <?php echo e(Auth::user()->first_name); ?> <?php echo e(Auth::user()->last_name); ?>

                            <?php endif; ?>
                        </h4>
                        <small>
                            
                            <?php if(Auth::check()): ?>
                                <p>Classe : <?php echo e(Auth::user()->currentClass->libelle ?? 'Non définie'); ?></p>
                                <p>Matricule : <?php echo e(Auth::user()->matricule ?? 'Non défini'); ?></p>
                                <p>Sexe : <?php echo e(Auth::user()->sexe ?? 'Non défini'); ?></p>
                            <?php endif; ?>
                        </small>
                    </div>
                </div>
            </div>
        </div>
        Page Header End -->


        <!-- About Start 
        <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-5 align-items-center">
                    <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.1s">
                        <h1 class="mb-4">Learn More About Our Work And Our Cultural Activities</h1>
                        <p>Tempor erat elitr rebum at clita. Diam dolor diam ipsum sit. Aliqu diam amet diam et eos. Clita erat ipsum et lorem et sit, sed stet lorem sit clita duo justo magna dolore erat amet</p>
                        <p class="mb-4">Stet no et lorem dolor et diam, amet duo ut dolore vero eos. No stet est diam rebum amet diam ipsum. Clita clita labore, dolor duo nonumy clita sit at, sed sit sanctus dolor eos, ipsum labore duo duo sit no sea diam. Et dolor et kasd ea. Eirmod diam at dolor est vero nonumy magna.</p>
                        <div class="row g-4 align-items-center">
                            <div class="col-sm-6">
                                <a class="btn btn-primary rounded-pill py-3 px-5" href="">Read More</a>
                            </div>
                            <div class="col-sm-6">
                                <div class="d-flex align-items-center">
                                    <img class="rounded-circle flex-shrink-0" src="img/user.jpg" alt="" style="width: 45px; height: 45px;">
                                    <div class="ms-3">
                                        <h6 class="text-primary mb-1">Jhon Doe</h6>
                                        <small>CEO & Founder</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 about-img wow fadeInUp" data-wow-delay="0.5s">
                        <div class="row">
                            <div class="col-12 text-center">
                                <img class="img-fluid w-75 rounded-circle bg-light p-3" src="img/about-1.jpg" alt="">
                            </div>
                            <div class="col-6 text-start" style="margin-top: -150px;">
                                <img class="img-fluid w-100 rounded-circle bg-light p-3" src="img/about-2.jpg" alt="">
                            </div>
                            <div class="col-6 text-end" style="margin-top: -150px;">
                                <img class="img-fluid w-100 rounded-circle bg-light p-3" src="img/about-3.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
         About End -->


        <!-- Call To Action Start 
        <div class="container-xxl py-5">
            <div class="container">
                <div class="bg-light rounded">
                    <div class="row g-0">
                        <div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s" style="min-height: 400px;">
                            <div class="position-relative h-100">
                                <img class="position-absolute w-100 h-100 rounded" src="img/call-to-action.jpg" style="object-fit: cover;">
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeIn" data-wow-delay="0.5s">
                            <div class="h-100 d-flex flex-column justify-content-center p-5">
                                <h1 class="mb-4">Become A Teacher</h1>
                                <p class="mb-4">Tempor erat elitr rebum at clita. Diam dolor diam ipsum sit. Aliqu diam amet diam et eos.
                                    Clita erat ipsum et lorem et sit, sed stet lorem sit clita duo justo magna dolore erat amet
                                </p>
                                <a class="btn btn-primary py-3 px-5" href="">Get Started Now<i class="fa fa-arrow-right ms-2"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        Call To Action End -->

        
        <!-- Classes Start -->
        <!-- Facilities Start -->
        <div class="container-xxl py-5">
            <div class="container">
               
                <div class="row g-4">
                    
                    
<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mb-4 text-center">Emploi du Temps</h1>
    

    <?php
        $jours = [
            1 => 'Lundi',
            2 => 'Mardi',
            3 => 'Mercredi',
            4 => 'Jeudi',
            5 => 'Vendredi',
            6 => 'Samedi'
        ];
    ?>

    <?php $__currentLoopData = $jours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num => $nomJour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><?php echo e($nomJour); ?></h4>
            </div>
            <div class="card-body">

                
                <h5 class="text-secondary">Matin</h5>
                <?php if(isset($mornings[$num]) && $mornings[$num]->count() > 0): ?>
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Heure</th>
                                <th>Matière</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $mornings[$num]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cours): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($cours->morningTime->debut ?? ''); ?> - <?php echo e($cours->morningTime->fin ?? ''); ?></td>
                                    <td><?php echo e($cours->matter->libelle ?? 'N/A'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p class="text-muted">Aucun cours le matin.</p>
                <?php endif; ?>

                
                <h5 class="text-secondary mt-3">Après-midi</h5>
                <?php if(isset($afters[$num]) && $afters[$num]->count() > 0): ?>
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Heure</th>
                                <th>Matière</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $afters[$num]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cours): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($cours->afterNoonTime->debut ?? ''); ?> - <?php echo e($cours->afterNoonTime->fin ?? ''); ?></td>
                                    <td><?php echo e($cours->matter->libelle ?? 'N/A'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p class="text-muted">Aucun cours l'après-midi.</p>
                <?php endif; ?>

            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php $__env->stopSection(); ?>
                        
            </div>
        </div>
        <!-- Facilities End -->



        


        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-0.5 mt-1 wow fadeIn" style="position: fixed; bottom: 0; left: 0;width: 100%; z-index: 999;" data-wow-delay="0.1s">
            
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        
                        <div class="col-md-6 text-center text-md-end">
                            <div class="footer-menu">
                                <a href="">Home</a>
                                <a href="">Cookies</a>
                                <a href="">Help</a>
                                <a href="">FQAs</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->


        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('lib/wow/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/easing/easing.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/waypoints/waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('lib/owlcarousel/owl.carousel.min.js')); ?>"></script>

    <!-- Template Javascript -->
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
</body>

</html>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/educasnsa/public_html/academie/educoach/resources/views/emploi_du_temps.blade.php ENDPATH**/ ?>