<?php $__env->startSection('title', 'Notes de l\'élève'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Notes</h1>

    <p><strong>Nom de l'établissement :</strong> <?php echo e($school->name_school ?? 'Non défini'); ?></p>
    <p><strong>Matricule de l'élève :</strong> <?php echo e($student->matricule ?? 'Non défini'); ?></p>
    <p><strong>School ID :</strong> <?php echo e($school->id ?? 'Non défini'); ?></p>

    <?php
        $projectBUrl = rtrim(config('services.projectb.url'), '/');
        $imageName   = optional(optional($school)->setting)->image;
        $logoUrl     = $imageName ? $projectBUrl . '/storage/' . $imageName : null;
    ?>

    <?php if($logoUrl): ?>
        <img src="<?php echo e($logoUrl); ?>" alt="Logo de <?php echo e($school->name_school); ?>" style="max-height:100px;">
    <?php else: ?>
        <p>Logo non disponible</p>
    <?php endif; ?>

    <hr>

    <h3>Liste des notes</h3>
    
    <?php
        $trimestres = [
            1 => 'Trimestre 1',
            2 => 'Trimestre 2',
            3 => 'Trimestre 3'
        ];
    ?>

    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <h3 class="mt-4"><?php echo e($label); ?></h3>
        <?php if(isset($notes[$id]) && $notes[$id]->count() > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Matière</th>
                        <th>Note</th>
                        <th>Type évaluation</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $notes[$id]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($note->evaluation->levelMatter->matter->libelle ?? 'N/A'); ?></td>
                            <td><?php echo e($note->note); ?></td>
                            <td><?php echo e($note->evaluation->evaluation_type_id); ?></td>
                            <td><?php echo e($note->evaluation->date_create); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Aucune note enregistrée.</p>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <p>(Les notes de l’élève apparaîtront ici...)</p>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/educasnsa/public_html/academie/educoach/resources/views/notes.blade.php ENDPATH**/ ?>