@extends('layouts.app')

@section('content')
<div class="container mt-4">

    <h3 class="mb-4">Recalcul des moyennes</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    
    <table class="table table-bordered table-striped mb-0">
    <thead>
        <tr>
            <th>Inscription ID</th>
            <th>Matières</th>
            <th>Moyenne générale</th>
        </tr>
    </thead>
    <tbody>
        @foreach($resultats as $eleve)
            <tr>
                <td>{{ $eleve['inscription_id'] }}</td>
                <td>
                    <ul>
                        @foreach($eleve['matieres'] as $matiere)
                            <li>{{ $matiere['matiere'] }} : {{ $matiere['moyenne'] }}</li>
                        @endforeach
                    </ul>
                </td>
                <td>{{ $eleve['moyenne_generale'] ?? 'NC' }}</td>
            </tr>
        @endforeach
    </tbody>
</table>


</div>
@endsection
