@extends('layouts.app')

@section('title', 'Notes de l\'élève')

@section('content')
<div class="container">
    <h1>Notes</h1>

    <p><strong>Nom de l'établissement :</strong> {{ $school->name_school ?? 'Non défini' }}</p>
    <p><strong>Matricule de l'élève :</strong> {{ $student->matricule ?? 'Non défini' }}</p>
    <p><strong>School ID :</strong> {{ $school->id ?? 'Non défini' }}</p>

    @php
        $projectBUrl = rtrim(config('services.projectb.url'), '/');
        $imageName   = optional(optional($school)->setting)->image;
        $logoUrl     = $imageName ? $projectBUrl . '/storage/' . $imageName : null;
    @endphp

    @if($logoUrl)
        <img src="{{ $logoUrl }}" alt="Logo de {{ $school->name_school }}" style="max-height:100px;">
    @else
        <p>Logo non disponible</p>
    @endif

    <hr>

    <h3>Liste des notes</h3>
    {{-- Ici tu pourras afficher les vraies notes depuis la table correspondante --}}
    @php
        $trimestres = [
            1 => 'Trimestre 1',
            2 => 'Trimestre 2',
            3 => 'Trimestre 3'
        ];
    @endphp

    @foreach($trimestres as $id => $label)
        <h3 class="mt-4">{{ $label }}</h3>
        @if(isset($notes[$id]) && $notes[$id]->count() > 0)
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Matière</th>
                        <th>Note</th>
                        <th>Type évaluation</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($notes[$id] as $note)
                        <tr>
                            <td>{{ $note->evaluation->levelMatter->matter->libelle ?? 'N/A' }}</td>
                            <td>{{ $note->note }}</td>
                            <td>{{ $note->evaluation->evaluation_type_id }}</td>
                            <td>{{ $note->evaluation->date_create }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p>Aucune note enregistrée.</p>
        @endif
    @endforeach
    <p>(Les notes de l’élève apparaîtront ici...)</p>
</div>
@endsection
