@extends('layouts.app')

@section('content')

<div class="container mt-4">

```
<h3 class="mb-4">Recalcul des moyennes - {{ $trimestre->libelle }}</h3>

@php
    // Fonction pour ajouter le suffixe français du rang
    function suffixe_francais($rang) {
        if ($rang == 1) return $rang . 'er';
        return $rang . 'e';
    }
@endphp

<table class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>Inscription ID</th>
            <th>Matières & Moyennes (coef)</th>
            <th>Moyenne générale</th>
            <th>Rang</th>
        </tr>
    </thead>
    <tbody>
        @foreach($resultats as $eleve)
            <tr>
                <td>{{ $eleve['inscription_id'] }}</td>
                <td>
                    @if(!empty($eleve['matieres']))
                        <ul>
                            @foreach($eleve['matieres'] as $matiere)
                                <li>
                                    {{ $matiere['matiere'] }} (coef: {{ $matiere['coef'] }}) : {{ $matiere['moyenne'] }}
                                </li>
                            @endforeach
                        </ul>
                    @else
                        NC
                    @endif
                </td>
                <td>{{ $eleve['moyenne_generale'] ?? 'NC' }}</td>
                <td>
                    @if($eleve['rang'])
                        {{ suffixe_francais($eleve['rang']) }}
                    @else
                        NC
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
```

</div>
@endsection
