<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TimeMorning extends Model
{
    protected $table = 'time_mornings';

    // Champs pouvant être remplis en masse
    protected $fillable = [
        'school_id',
        'classe_id',
        'matter_id',
        'morning_time_id',
        'week_day_id'
    ];

    /**
     * Relation avec la matière du cours
     */
    public function matter()
    {
        return $this->belongsTo(Matter::class, 'matter_id');
    }

    /**
     * Relation avec l'heure du matin (début, fin)
     */
    public function morningTime()
    {
        return $this->belongsTo(MorningTime::class, 'morning_time_id', 'id');
    }

    /**
     * Relation avec le jour de la semaine
     */
    public function weekDay()
    {
        return $this->belongsTo(WeekDay::class, 'week_day_id');
    }

    /**
     * Scope pour filtrer par classe et école
     */
    public function scopeForClasse($query, $schoolId, $classeId)
    {
        return $query->where('school_id', $schoolId)
                     ->where('classe_id', $classeId);
    }
}
