<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TimeAfter extends Model
{
    protected $table = 'time_afters';

    protected $fillable = [
        'school_id',
        'classe_id',
        'matter_id',
        'after_noon_time_id',
        'week_day_id'
    ];

    /**
     * Relation avec la matière
     */
    public function matter()
    {
        return $this->belongsTo(Matter::class, 'matter_id');
    }

    /**
     * Relation avec le jour de la semaine
     */
    public function weekDay()
    {
        return $this->belongsTo(WeekDay::class, 'week_day_id');
    }

    /**
     * Relation avec l'heure de l'après-midi (début, fin)
     */
    public function afterNoonTime()
    {
        return $this->belongsTo(AfterNoonTime::class, 'after_noon_time_id', 'id');
    }
}

