<?php 

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable; 
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\School;
use App\Models\Inscription;
use App\Models\Classe;

class Student extends Authenticatable
{
    use HasFactory;

    protected $table = 'students';
    protected $primaryKey = 'id';

    protected $fillable = [
        'first_name',
        'last_name',
        'matricule',
        'school_id',
        'sexe',
        // autres colonnes nécessaires
    ];

    /**
     * Relation avec l’école
     */
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    /**
     * Relation avec toutes les inscriptions
     */
    public function inscriptions()
    {
        return $this->hasMany(Inscription::class, 'student_id');
    }

    /**
     * Relation pratique pour récupérer la dernière inscription
     */
    public function latestInscription()
    {
        return $this->hasOne(Inscription::class, 'student_id')->latest('id');
    }

    /**
     * Relation pratique pour récupérer la classe actuelle via la dernière inscription
     */
    public function currentClass()
    {
        return $this->hasOneThrough(
            Classe::class,        // Modèle final
            Inscription::class,   // Modèle intermédiaire
            'student_id',         // FK sur Inscription
            'id',                 // PK sur Classe
            'id',                 // PK sur Student
            'classe_id'           // FK sur Inscription vers Classe
        );
    }
}
