<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Student;
use App\Models\Setting; // ⚡️ N’oublie pas d’importer Setting

class School extends Model
{
    protected $fillable = ['name_school', 'num_autorisation'];

    // Relation : une école a plusieurs élèves
    public function students()
    {
        return $this->hasMany(Student::class);
    }

    // Relation : une école a une configuration (logo, etc.)
    public function setting()
    {
        return $this->hasOne(Setting::class, 'school_id');
    }
}
