<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Level;
use App\Models\Matter;
use App\Models\Coefficient;

class LevelMatter extends Model
{
    protected $table = 'level_matter';
    protected $fillable = ['school_id', 'level_id', 'matter_id', 'coefficient_id'];

    public function level()
    {
        return $this->belongsTo(Level::class, 'level_id');
    }

    public function matter()
    {
        return $this->belongsTo(Matter::class, 'matter_id');
    }

    public function coefficient()
    {
        return $this->belongsTo(Coefficient::class, 'coefficient_id');
    }
}
