<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Student;
use App\Models\Classe;
use App\Models\School;
use App\Models\GetNote;

class Inscription extends Model
{
    protected $fillable = ['student_id', 'school_id', 'classe_id'];

    /**
     * L'inscription appartient à un étudiant
     */
    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    /**
     * L'inscription appartient à une classe
     */
    public function classe()
    {
        return $this->belongsTo(Classe::class, 'classe_id');
    }

    /**
     * L'inscription appartient à une école
     */
    public function school()
    {
        return $this->belongsTo(School::class, 'school_id');
    }

    /**
     * Une inscription a plusieurs notes
     */
    public function notes()
    {
        return $this->hasMany(GetNote::class, 'inscription_id');
    }
}
