<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Evaluation;
use App\Models\Inscription;

class GetNote extends Model
{
    protected $table = 'get_notes';
    protected $fillable = ['note', 'evaluation_id', 'inscription_id'];

    /**
     * Relation avec l'évaluation
     */
    public function evaluation()
    {
        return $this->belongsTo(Evaluation::class, 'evaluation_id');
    }

    /**
     * Relation avec l'inscription de l'élève
     */
    public function inscription()
    {
        return $this->belongsTo(Inscription::class, 'inscription_id');
    }
}
