<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\CuttingSchoolYear;
use App\Models\LevelMatter;
use App\Models\EvaluationType;

class Evaluation extends Model
{
    protected $table = 'evaluations';
    protected $fillable = [
        'notee', 
        'classe_id', 
        'cutting_school_year_id', 
        'level_matter_id', 
        'sub_matter_id', 
        'evaluation_type_id'
    ];

    public function cuttingSchoolYear()
    {
    return $this->belongsTo(CuttingSchoolYear::class, 'cutting_school_year_id');
    }

    public function levelMatter()
    {
        return $this->belongsTo(LevelMatter::class, 'level_matter_id');
    }

    public function evaluationType()
    {
        return $this->belongsTo(EvaluationType::class, 'evaluation_type_id');
    }
}
