<?php
namespace App\Http\Controllers;

use App\Models\GetNote;
use Illuminate\Http\Request;

class NoteController extends Controller
{
    public function showTrimestre1($studentId)
    {
        $notes = GetNote::with([
            'evaluation.levelMatter.matter',
            'evaluation.levelMatter.coefficient',
            'evaluation.cuttingSchoolYear.cutting'
        ])
        ->whereHas('evaluation.cuttingSchoolYear.cutting', function ($q) {
            $q->where('libelle', '1er trimestre');
        })
        ->whereHas('inscription', function ($q) use ($studentId) {
            $q->where('student_id', $studentId);
        })
        ->get();

        return view('notes.trimestre1', compact('notes'));
    }
}
