<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class GradeController extends Controller
{
    /**
     * Affiche les notes du 1er trimestre pour l'élève connecté
     */
    public function trimestre1(Request $request)
    {
        if (!Auth::check()) {
            return redirect('https://educas-nsa.net/academie/connexion');
        }

        $student = Auth::user();

        // Récupérer une inscription (ici on prend la plus récente) — adapte si tu as une logique différente
        $inscription = $student->inscriptions()->latest('id')->first();

        if (!$inscription) {
            // Pas d'inscription -> on renvoie vue vide
            $notes = collect();
            $moyennesParMatiere = collect();
            return view('notes.trimestre1', compact('student', 'notes', 'moyennesParMatiere'));
        }

        // Requête pour récupérer les notes liées au 1er trimestre
        $notes = DB::table('get_notes')
            ->join('evaluations', 'get_notes.evaluation_id', '=', 'evaluations.id')
            ->join('cutting_school_year', 'evaluations.cutting_school_year_id', '=', 'cutting_school_year.id')
            ->join('cuttings', 'cutting_school_year.cutting_id', '=', 'cuttings.id')
            ->join('level_matter', 'evaluations.level_matter_id', '=', 'level_matter.id')
            ->join('matters', 'level_matter.matter_id', '=', 'matters.id')
            ->join('coefficients', 'level_matter.coefficient_id', '=', 'coefficients.id')
            ->select(
                'get_notes.id as note_id',
                'get_notes.note as note',
                'evaluations.id as evaluation_id',
                'matters.id as matter_id',
                'matters.libelle as matiere',
                'coefficients.valeur as coefficient',
                'cuttings.libelle as cutting'
            )
            ->where('get_notes.inscription_id', $inscription->id)
            ->where('cuttings.libelle', 'Trimestre 1') // si tu préfères utiliser l'id du cutting, remplace par where('cuttings.id', $id)
            ->orderBy('matters.libelle')
            ->get();

        // Collection Laravel pour manipulation + calculs
        $notes = collect($notes);

        // Calcul des totaux pondérés et moyennes par matière :
        // moyenne_matiere = sum(note * coeff) / sum(coeff)
        $moyennesParMatiere = $notes
            ->groupBy('matiere')
            ->map(function ($lignes, $matiere) {
                $sommePondere = $lignes->reduce(function ($carry, $item) {
                    return $carry + ($item->note * $item->coefficient);
                }, 0);
                $sommeCoeff = $lignes->sum('coefficient');
                $moy = $sommeCoeff > 0 ? round($sommePondere / $sommeCoeff, 2) : null;

                return (object)[
                    'matiere' => $matiere,
                    'somme_pondere' => $sommePondere,
                    'somme_coefficient' => $sommeCoeff,
                    'moyenne' => $moy,
                    'count' => $lignes->count(),
                ];
            });

        return view('notes.trimestre1', compact('student', 'notes', 'moyennesParMatiere'));
    }
}
