<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DevoirController extends Controller
{
    public function index()
    {
        $student = Auth::user();

        // Classe actuelle
        $class = $student->currentClass;

        if (!$class) {
            return back()->with('error', "La classe de l'élève n'est pas définie.");
        }

        // Année scolaire actuelle
        $currentYear = session('cutting_school_year_id');

        // Récupération des devoirs correspondant à la classe, l'école et l'année
        $devoirs = DB::table('devoirs')
            ->join('matters', 'matters.id', '=', 'devoirs.matter_id')
            ->select(
                'devoirs.*',
                'matters.libelle as matiere'
            )
            ->where('devoirs.classe_id', $class->id)
            ->where('devoirs.school_id', $student->school_id)
            ->orderBy('period', 'ASC') // 1 puis 2
            ->orderBy('date', 'ASC')
            ->orderBy('debut', 'ASC')
            ->get();

        return view('devoirs.index', compact('student', 'class', 'devoirs'));
    }
}
